/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.keystore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreDAO;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreData;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreDataEvent;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreStorageImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityVersion;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.ssl.spi.KeyStoreStorage;
import org.sonatype.nexus.ssl.spi.KeyStoreStorageManager;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="ssl")
@Singleton
public class KeyStoreStorageManagerImpl
extends ConfigStoreSupport<KeyStoreDAO>
implements KeyStoreStorageManager {
    private final EventManager eventManager;

    @Inject
    public KeyStoreStorageManagerImpl(DataSessionSupplier sessionSupplier, EventManager eventManager) {
        super(sessionSupplier);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    public KeyStoreStorage createStorage(String keyStoreName) {
        return new KeyStoreStorageImpl(this, keyStoreName);
    }

    @Transactional
    @Nullable
    public boolean exists(String keyStoreName) {
        return ((KeyStoreDAO)this.dao()).load(keyStoreName).isPresent();
    }

    public ByteArrayInputStream load(String keyStoreName) {
        Optional<KeyStoreData> data = this.doLoad(keyStoreName);
        Preconditions.checkState((boolean)data.isPresent(), (String)"key store %s does not exist", (Object)keyStoreName);
        this.postEvent(keyStoreName);
        return new ByteArrayInputStream(data.get().getBytes());
    }

    @Transactional
    protected Optional<KeyStoreData> doLoad(String keyStoreName) {
        return ((KeyStoreDAO)this.dao()).load(keyStoreName);
    }

    public void save(String keyStoreName, ByteArrayOutputStream out) {
        KeyStoreData data = new KeyStoreData();
        data.setName(keyStoreName);
        data.setBytes(out.toByteArray());
        this.doSave(data);
        this.postEvent(keyStoreName);
    }

    @Transactional
    protected void doSave(KeyStoreData data) {
        ((KeyStoreDAO)this.dao()).save(data);
    }

    private void postEvent(final String keyStoreName) {
        this.eventManager.post((Object)new KeyStoreDataEvent(){

            @Override
            public boolean isLocal() {
                return true;
            }

            @Override
            public EntityVersion getVersion() {
                return null;
            }

            @Override
            public String getRemoteNodeId() {
                return null;
            }

            @Override
            public String getKeyStoreName() {
                return keyStoreName;
            }
        });
    }
}

