/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import org.apache.http.protocol.HttpContext;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.httpclient.SSLContextSelector;
import org.sonatype.nexus.ssl.TrustStore;

@Named
@Singleton
public class HttpContextAttributeSSLContextSelector
extends ComponentSupport
implements SSLContextSelector {
    private final TrustStore trustStore;

    @Inject
    public HttpContextAttributeSSLContextSelector(TrustStore trustStore) {
        this.trustStore = (TrustStore)Preconditions.checkNotNull((Object)trustStore);
    }

    public SSLContext select(HttpContext context) {
        Object useTrustStore = context.getAttribute("nexus.httpclient.ssl.trustStore");
        if (Boolean.TRUE.equals(useTrustStore)) {
            return this.trustStore.getSSLContext();
        }
        return null;
    }
}

