/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.cleanup.ProCleanupFeatureCheck;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.cleanup.rest.CleanupPolicyRequestValidator;
import org.sonatype.nexus.cleanup.rest.CleanupPolicyXO;
import org.sonatype.nexus.repository.content.kv.global.GlobalKeyValueStore;
import org.sonatype.nexus.repository.content.kv.global.NexusKeyValue;
import org.sonatype.nexus.rest.ValidationErrorXO;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Singleton
@Named
public class ProCleanupPolicyRequestValidator
implements CleanupPolicyRequestValidator {
    private final ProCleanupFeatureCheck featureCheck;
    private final GlobalKeyValueStore globalKeyValueStore;

    @Inject
    public ProCleanupPolicyRequestValidator(ProCleanupFeatureCheck featureCheck, GlobalKeyValueStore globalKeyValueStore) {
        this.featureCheck = (ProCleanupFeatureCheck)((Object)Preconditions.checkNotNull((Object)((Object)featureCheck)));
        this.globalKeyValueStore = (GlobalKeyValueStore)Preconditions.checkNotNull((Object)globalKeyValueStore);
    }

    public void validate(CleanupPolicyXO cleanupPolicyXO) {
        this.validateRetainAttributes(cleanupPolicyXO);
    }

    private void validateRetainAttributes(CleanupPolicyXO cleanupPolicyXO) {
        if (cleanupPolicyXO.getRetain() != null || cleanupPolicyXO.getSortBy() != null) {
            this.validateFeatureAvailability(cleanupPolicyXO.getFormat());
            this.validateNormalizationState(cleanupPolicyXO.getFormat());
            if (cleanupPolicyXO.getRetain() != null && cleanupPolicyXO.getSortBy() == null) {
                throw new ValidationErrorsException("sortBy", "sortBy should be defined if retain is set");
            }
            if (cleanupPolicyXO.getSortBy() != null && cleanupPolicyXO.getRetain() == null) {
                throw new ValidationErrorsException("retain", "retain should be defined if sortBy is set");
            }
        }
    }

    private void validateFeatureAvailability(String format) {
        if (!this.featureCheck.isRetainSupported(format)) {
            if (!this.featureCheck.isProVersion()) {
                throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ValidationErrorXO("Exclusion criteria is not supported.")).build());
            }
            if (!this.featureCheck.isPostgres()) {
                throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ValidationErrorXO("The current data source is not supported by the exclusion criteria.")).build());
            }
            throw new ValidationErrorsException("format", "The specified format is not supported by the exclusion criteria.");
        }
    }

    private void validateNormalizationState(String format) {
        boolean isFormatNormalized = this.globalKeyValueStore.getKey(String.format("%s.normalized.version.available", format)).map(NexusKeyValue::getAsBoolean).orElse(false);
        if (!isFormatNormalized) {
            throw new ValidationErrorsException("format", "the specified format is not ready for the exclusion criteria.");
        }
    }
}

