/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup.internal;

import com.sonatype.nexus.cleanup.internal.CleanupBrowseQuery;
import com.sonatype.nexus.cleanup.internal.CleanupBrowseQueryParams;
import org.apache.ibatis.jdbc.SQL;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.content.SqlGenerator;
import org.sonatype.nexus.repository.content.SqlQueryParameters;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;

public class NpmCleanupBrowseQuery
extends CleanupBrowseQuery {
    public static final String FORMAT = "npm";

    @Override
    protected String getFormat() {
        return FORMAT;
    }

    @Override
    protected Continuation<FluentComponent> doBrowse(FluentComponents fluentComponents, CleanupBrowseQueryParams params) {
        if (params.includeAssets()) {
            return fluentComponents.selectComponentsWithAssets((SqlGenerator)this, (SqlQueryParameters)params);
        }
        return fluentComponents.selectComponents((SqlGenerator)this, (SqlQueryParameters)params);
    }

    @Override
    protected void select(SQL sql, CleanupBrowseQueryParams params) {
        if (params.getCleanupCriteria().hasFilterCriteriaSelected()) {
            if (params.includeAssets()) {
                this.buildPreviewQuery(sql, params);
            } else {
                this.buildCleanupQuery(sql, params);
            }
        } else {
            ((SQL)((SQL)sql.SELECT("*")).FROM("npm_component")).LIMIT(0);
        }
    }

    private void buildPreviewQuery(SQL sql, CleanupBrowseQueryParams params) {
        ((SQL)((SQL)((SQL)sql.SELECT("cleanup_components.orderedToken, component.*, asset.*")).FROM(String.format("(%s) AS cleanup_components", this.buildCleanupQuery(params)))).LEFT_OUTER_JOIN("npm_component AS component ON component.component_id = cleanup_components.component_id")).LEFT_OUTER_JOIN("npm_asset AS asset ON component.component_id = asset.component_id");
        if (params.getRetainCriteria().hasRetainCriteriaSelected() && params.getRetainCriteria().getSortBy().equals("version")) {
            sql.ORDER_BY("component.normalized_version DESC");
        } else {
            sql.ORDER_BY("component.component_id");
        }
    }

    private String buildCleanupQuery(CleanupBrowseQueryParams params) {
        SQL sql = new SQL();
        this.buildCleanupQuery(sql, params);
        return sql.toString();
    }

    private void buildCleanupQuery(SQL sql, CleanupBrowseQueryParams params) {
        boolean isRetainByVersion;
        boolean bl = isRetainByVersion = params.getRetainCriteria().hasRetainCriteriaSelected() && params.getRetainCriteria().getSortBy().equals("version");
        if (params.includeAssets()) {
            sql.SELECT(this.idAttribute);
        } else {
            sql.SELECT("npm_component.*, NULL AS asset_id");
        }
        if (isRetainByVersion) {
            sql.SELECT("npm_component.normalized_version AS orderedToken");
        } else {
            sql.SELECT("npm_component.component_id AS orderedToken");
        }
        sql.FROM("npm_component");
        this.joinTables(sql, params);
        this.setWhereClauses(sql, params, isRetainByVersion);
        sql.GROUP_BY(this.idAttribute);
        this.setHavingClauses(sql, params);
        if (isRetainByVersion) {
            sql.ORDER_BY("npm_component.normalized_version DESC");
        } else {
            sql.ORDER_BY(this.idAttribute);
        }
        if (params.getRetainCriteria().hasRetainCriteriaSelected() && params.getRetainCriteria().getRetain() > 0 && params.getContinuationToken() == null) {
            sql.OFFSET((long)params.getRetainCriteria().getRetain());
        }
        if (params.getLimit() > 0) {
            sql.LIMIT(params.getLimit());
        }
    }

    private void joinTables(SQL sql, CleanupBrowseQueryParams params) {
        if (params.getCleanupCriteria().hasFilterCriteriaSelected()) {
            sql.LEFT_OUTER_JOIN("npm_asset on npm_component.component_id = npm_asset.component_id");
        }
        if (params.getCleanupCriteria().getLastDownloaded() != null || params.getCleanupCriteria().getLastBlobUpdated() != null) {
            sql.LEFT_OUTER_JOIN("npm_asset_blob ON npm_asset.asset_blob_id = npm_asset_blob.asset_blob_id");
        }
    }

    private void setWhereClauses(SQL sql, CleanupBrowseQueryParams params, boolean isRetainByVersion) {
        if (params.getName() == null && params.getNamespace() == null && !params.getRetainCriteria().hasRetainCriteriaSelected()) {
            sql.WHERE("npm_component.repository_id = #{params.repositoryId}");
        } else {
            ((SQL)((SQL)((SQL)((SQL)sql.WHERE("npm_component.repository_id = #{params.repositoryId}")).AND()).WHERE("npm_component.namespace = #{params.namespace}")).AND()).WHERE("npm_component.name = #{params.name}");
        }
        if (params.getCleanupCriteria().isPrerelease() != null) {
            if (params.getCleanupCriteria().isPrerelease().booleanValue()) {
                ((SQL)sql.AND()).WHERE("(position('-' in npm_component.version) > 0)");
            } else {
                ((SQL)sql.AND()).WHERE("(position('-' in npm_component.version) = 0)");
            }
        }
        if (params.getContinuationToken() != null) {
            if (isRetainByVersion) {
                ((SQL)sql.AND()).WHERE("npm_component.normalized_version < #{params.continuationToken}");
            } else {
                ((SQL)sql.AND()).WHERE("npm_component.component_id > #{params.continuationToken}");
            }
        }
    }

    private void setHavingClauses(SQL sql, CleanupBrowseQueryParams params) {
        boolean havingAdded = false;
        if (params.getCleanupCriteria().getLastDownloaded() != null) {
            sql.HAVING("(max(coalesce(npm_asset.last_downloaded, npm_asset_blob.blob_created)) <= (now() - interval '${params.cleanupCriteria.lastDownloaded} seconds'))");
            havingAdded = true;
        }
        if (params.getCleanupCriteria().getLastBlobUpdated() != null) {
            if (havingAdded) {
                sql.AND();
            }
            sql.HAVING("(max(npm_asset_blob.blob_created) <= (now() - interval '${params.cleanupCriteria.lastBlobUpdated} seconds'))");
            havingAdded = true;
        }
        if (params.getCleanupCriteria().getRegex() != null) {
            if (havingAdded) {
                sql.AND();
            }
            sql.HAVING("bool_or(npm_asset.path ~ #{params.cleanupCriteria.regex})");
        }
    }
}

