/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup.internal;

import com.sonatype.nexus.cleanup.internal.CleanupBrowseQuery;
import com.sonatype.nexus.cleanup.internal.CleanupBrowseQueryParams;
import org.apache.ibatis.jdbc.SQL;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.content.SqlGenerator;
import org.sonatype.nexus.repository.content.SqlQueryParameters;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;

public class DockerCleanupBrowseQuery
extends CleanupBrowseQuery {
    public static final String FORMAT = "docker";

    @Override
    protected String getFormat() {
        return FORMAT;
    }

    @Override
    protected Continuation<FluentComponent> doBrowse(FluentComponents fluentComponents, CleanupBrowseQueryParams params) {
        return fluentComponents.selectComponents((SqlGenerator)this, (SqlQueryParameters)params);
    }

    @Override
    protected void select(SQL sql, CleanupBrowseQueryParams params) {
        if ((params.getCleanupCriteria().isPrerelease() == null || !params.getCleanupCriteria().isPrerelease().booleanValue()) && params.getCleanupCriteria().hasFilterCriteriaSelected()) {
            this.buildCleanupQuery(sql, params);
        } else {
            ((SQL)((SQL)sql.SELECT("*")).FROM("docker_component")).LIMIT(0);
        }
    }

    private void buildCleanupQuery(SQL sql, CleanupBrowseQueryParams params) {
        boolean isRetainByDate = params.getRetainCriteria().hasRetainCriteriaSelected() && params.getRetainCriteria().getSortBy().equals("date");
        sql.SELECT("docker_component.*");
        if (isRetainByDate) {
            sql.SELECT("docker_asset_blob.blob_created AS orderedToken");
        } else {
            sql.SELECT("docker_component.component_id AS orderedToken");
        }
        sql.FROM("docker_component");
        this.joinTables(sql, params, isRetainByDate);
        this.setWhereClauses(sql, params, isRetainByDate);
        sql.GROUP_BY("docker_component.component_id");
        if (isRetainByDate) {
            sql.GROUP_BY("docker_asset_blob.blob_created");
        }
        this.setHavingClauses(sql, params);
        if (isRetainByDate) {
            sql.ORDER_BY("docker_asset_blob.blob_created DESC");
        } else {
            sql.ORDER_BY("docker_component.component_id");
        }
        if (params.getRetainCriteria().hasRetainCriteriaSelected() && params.getRetainCriteria().getRetain() > 0 && params.getContinuationToken() == null) {
            sql.OFFSET((long)params.getRetainCriteria().getRetain());
        }
        if (params.getLimit() > 0) {
            sql.LIMIT(params.getLimit());
        }
    }

    private void joinTables(SQL sql, CleanupBrowseQueryParams params, boolean isRetainByDate) {
        if (params.getCleanupCriteria().hasFilterCriteriaSelected() || isRetainByDate) {
            sql.LEFT_OUTER_JOIN("docker_asset on docker_component.component_id = docker_asset.component_id");
        }
        if (params.getCleanupCriteria().getLastDownloaded() != null || params.getCleanupCriteria().getLastBlobUpdated() != null || isRetainByDate) {
            sql.LEFT_OUTER_JOIN("docker_asset_blob ON docker_asset.asset_blob_id = docker_asset_blob.asset_blob_id");
        }
    }

    private void setWhereClauses(SQL sql, CleanupBrowseQueryParams params, boolean isRetainByDate) {
        if (params.getName() == null && params.getNamespace() == null && !params.getRetainCriteria().hasRetainCriteriaSelected()) {
            sql.WHERE("docker_component.repository_id = #{params.repositoryId}");
        } else {
            ((SQL)((SQL)((SQL)((SQL)sql.WHERE("docker_component.repository_id = #{params.repositoryId}")).AND()).WHERE("docker_component.namespace = #{params.namespace}")).AND()).WHERE("docker_component.name = #{params.name}");
        }
        if (params.getContinuationToken() != null) {
            if (isRetainByDate) {
                ((SQL)sql.AND()).WHERE("docker_asset_blob.blob_created < #{params.continuationToken}");
            } else {
                ((SQL)sql.AND()).WHERE("docker_component.component_id > #{params.continuationToken}");
            }
        }
    }

    private void setHavingClauses(SQL sql, CleanupBrowseQueryParams params) {
        boolean havingAdded = false;
        if (params.getCleanupCriteria().getLastDownloaded() != null) {
            sql.HAVING("(max(coalesce(docker_asset.last_downloaded, docker_asset_blob.blob_created)) <= (now() - interval '${params.cleanupCriteria.lastDownloaded} seconds'))");
            havingAdded = true;
        }
        if (params.getCleanupCriteria().getLastBlobUpdated() != null) {
            if (havingAdded) {
                sql.AND();
            }
            sql.HAVING("(max(docker_asset_blob.blob_created) <= (now() - interval '${params.cleanupCriteria.lastBlobUpdated} seconds'))");
            havingAdded = true;
        }
        if (params.getCleanupCriteria().getRegex() != null) {
            if (havingAdded) {
                sql.AND();
            }
            sql.HAVING("bool_or(docker_asset.path ~ #{params.cleanupCriteria.regex})");
        }
    }
}

