/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup.internal;

import com.sonatype.nexus.cleanup.internal.CleanupBrowseQuery;
import com.sonatype.nexus.cleanup.internal.CleanupBrowseQueryParams;
import org.apache.ibatis.jdbc.SQL;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.content.SqlGenerator;
import org.sonatype.nexus.repository.content.SqlQueryParameters;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;

public class DefaultCleanupBrowseQuery
extends CleanupBrowseQuery {
    @Override
    protected String getFormat() {
        return "${params.format}";
    }

    @Override
    protected Continuation<FluentComponent> doBrowse(FluentComponents fluentComponents, CleanupBrowseQueryParams params) {
        if (params.includeAssets()) {
            return fluentComponents.selectComponentsWithAssets((SqlGenerator)this, (SqlQueryParameters)params);
        }
        return fluentComponents.selectComponents((SqlGenerator)this, (SqlQueryParameters)params);
    }

    @Override
    protected void select(SQL sql, CleanupBrowseQueryParams params) {
        if ((params.getCleanupCriteria().isPrerelease() == null || !params.getCleanupCriteria().isPrerelease().booleanValue()) && params.getCleanupCriteria().hasFilterCriteriaSelected()) {
            if (params.includeAssets()) {
                this.buildPreviewQuery(sql, params);
            } else {
                this.buildCleanupQuery(sql, params);
            }
        } else {
            ((SQL)((SQL)sql.SELECT("*")).FROM("${params.format}_component")).LIMIT(0);
        }
    }

    private void buildPreviewQuery(SQL sql, CleanupBrowseQueryParams params) {
        ((SQL)((SQL)((SQL)((SQL)sql.SELECT("component.* , asset.*")).FROM(String.format("(%s) AS cleanup_components", this.buildCleanupQuery(params)))).LEFT_OUTER_JOIN("${params.format}_component AS component ON component.component_id = cleanup_components.component_id")).LEFT_OUTER_JOIN("${params.format}_asset AS asset ON component.component_id = asset.component_id")).ORDER_BY("component.component_id");
    }

    private String buildCleanupQuery(CleanupBrowseQueryParams params) {
        SQL sql = new SQL();
        this.buildCleanupQuery(sql, params);
        return sql.toString();
    }

    private void buildCleanupQuery(SQL sql, CleanupBrowseQueryParams params) {
        if (params.includeAssets()) {
            sql.SELECT(this.idAttribute);
        } else {
            sql.SELECT("${params.format}_component.*");
        }
        sql.FROM("${params.format}_component");
        this.joinTables(sql, params);
        this.setWhereClauses(sql, params);
        sql.GROUP_BY(this.idAttribute);
        this.setHavingClauses(sql, params);
        sql.ORDER_BY(this.idAttribute);
        if (params.getLimit() > 0) {
            sql.LIMIT(params.getLimit());
        }
    }

    private void joinTables(SQL sql, CleanupBrowseQueryParams params) {
        if (params.getCleanupCriteria().hasFilterCriteriaSelected()) {
            sql.LEFT_OUTER_JOIN("${params.format}_asset on ${params.format}_component.component_id = ${params.format}_asset.component_id");
        }
        if (params.getCleanupCriteria().getLastDownloaded() != null || params.getCleanupCriteria().getLastBlobUpdated() != null) {
            sql.LEFT_OUTER_JOIN("${params.format}_asset_blob ON ${params.format}_asset.asset_blob_id = ${params.format}_asset_blob.asset_blob_id");
        }
    }

    private void setWhereClauses(SQL sql, CleanupBrowseQueryParams params) {
        if (params.getName() == null && params.getNamespace() == null) {
            sql.WHERE("${params.format}_component.repository_id = #{params.repositoryId}");
        } else {
            ((SQL)((SQL)((SQL)((SQL)sql.WHERE("${params.format}_component.repository_id = #{params.repositoryId}")).AND()).WHERE("${params.format}_component.namespace = #{params.namespace}")).AND()).WHERE("${params.format}_component.name = #{params.name}");
        }
        if (params.getContinuationToken() != null) {
            ((SQL)sql.AND()).WHERE("${params.format}_component.component_id > #{params.continuationToken}");
        }
    }

    private void setHavingClauses(SQL sql, CleanupBrowseQueryParams params) {
        boolean havingAdded = false;
        if (params.getCleanupCriteria().getLastDownloaded() != null) {
            sql.HAVING("(max(coalesce(${params.format}_asset.last_downloaded, ${params.format}_asset_blob.blob_created)) <= (now() - interval '${params.cleanupCriteria.lastDownloaded} seconds'))");
            havingAdded = true;
        }
        if (params.getCleanupCriteria().getLastBlobUpdated() != null) {
            if (havingAdded) {
                sql.AND();
            }
            sql.HAVING("(max(${params.format}_asset_blob.blob_created) <= (now() - interval '${params.cleanupCriteria.lastBlobUpdated} seconds'))");
            havingAdded = true;
        }
        if (params.getCleanupCriteria().getRegex() != null) {
            if (havingAdded) {
                sql.AND();
            }
            sql.HAVING("bool_or(${params.format}_asset.path ~ #{params.cleanupCriteria.regex})");
        }
    }
}

