/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup.internal;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import org.sonatype.nexus.common.entity.Continuation;

public class CompositeComponentSetContinuation<Component>
extends ArrayList<Component>
implements Continuation<Component> {
    private static final String REGEX_SAFE_DELIMITER = "~";
    private String componentSetContinuationToken;
    private String componentContinuationToken;

    CompositeComponentSetContinuation() {
        this.componentSetContinuationToken = null;
        this.componentContinuationToken = null;
    }

    CompositeComponentSetContinuation(String continuationToken) {
        if (continuationToken == null) {
            this.componentSetContinuationToken = null;
            this.componentContinuationToken = null;
        } else {
            String[] tokens = continuationToken.split(REGEX_SAFE_DELIMITER);
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Invalid continuation token: " + continuationToken);
            }
            this.componentSetContinuationToken = this.decode(tokens[0]);
            this.componentContinuationToken = this.decode(tokens[1]);
        }
    }

    public String getComponentSetContinuationToken() {
        return this.componentSetContinuationToken;
    }

    public void setComponentSetContinuationToken(String setContinuationToken) {
        this.componentSetContinuationToken = setContinuationToken;
    }

    public String getComponentContinuationToken() {
        return this.componentContinuationToken;
    }

    public void setComponentContinuationToken(String componentContinuationToken) {
        this.componentContinuationToken = componentContinuationToken;
    }

    private String encode(String original) {
        return original == null ? "" : Base64.getEncoder().encodeToString(original.getBytes(StandardCharsets.UTF_8));
    }

    private String decode(String original) {
        return original.isEmpty() ? null : new String(Base64.getDecoder().decode(original), StandardCharsets.UTF_8);
    }

    public String nextContinuationToken() {
        if (this.componentSetContinuationToken == null && this.componentContinuationToken == null) {
            return null;
        }
        return String.valueOf(this.encode(this.componentSetContinuationToken)) + REGEX_SAFE_DELIMITER + this.encode(this.componentContinuationToken);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompositeComponentSetContinuation that = (CompositeComponentSetContinuation)o;
        return Objects.equals(this.componentSetContinuationToken, that.componentSetContinuationToken) && Objects.equals(this.componentContinuationToken, that.componentContinuationToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.componentSetContinuationToken, this.componentContinuationToken);
    }
}

