/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup.internal;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.cleanup.internal.CleanupBrowseQuery;
import com.sonatype.nexus.cleanup.internal.CompositeComponentSetContinuation;
import com.sonatype.nexus.cleanup.internal.DefaultCleanupBrowseQuery;
import com.sonatype.nexus.cleanup.internal.DockerCleanupBrowseQuery;
import com.sonatype.nexus.cleanup.internal.MavenCleanupBrowseQuery;
import com.sonatype.nexus.cleanup.internal.NpmCleanupBrowseQuery;
import com.sonatype.nexus.cleanup.internal.YumCleanupBrowseQuery;
import java.util.Map;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.content.search.ContinuationBrowse;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.ComponentSet;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.store.ComponentSetData;

public class ComponentSetCleanupBrowser
extends ComponentSupport
implements ContinuationBrowse<FluentComponent> {
    private static final CleanupBrowseQuery defaultCleanupQuery = new DefaultCleanupBrowseQuery();
    private final Repository repository;
    private final CleanupPolicy policy;
    private final Map<String, CleanupBrowseQuery> cleanupQueryByFormat;
    private final boolean includeAssets;

    public ComponentSetCleanupBrowser(Repository repository, CleanupPolicy policy, boolean includeAssets) {
        if (repository == null) {
            throw new IllegalArgumentException("Repository must not be null");
        }
        this.repository = repository;
        if (policy == null) {
            throw new IllegalArgumentException("Cleanup Policy must not be null");
        }
        this.policy = policy;
        this.cleanupQueryByFormat = this.initializeMap();
        this.includeAssets = includeAssets;
    }

    private Map<String, CleanupBrowseQuery> initializeMap() {
        return ImmutableMap.of((Object)"maven2", (Object)((Object)new MavenCleanupBrowseQuery()), (Object)"docker", (Object)((Object)new DockerCleanupBrowseQuery()), (Object)"npm", (Object)((Object)new NpmCleanupBrowseQuery()), (Object)"yum", (Object)((Object)new YumCleanupBrowseQuery()));
    }

    public Continuation<FluentComponent> browse(Integer limit, String continuationToken) {
        if (limit < 1) {
            throw new IllegalArgumentException("Browse limit must be at least 1");
        }
        this.log.debug("Request for components to clean with a limit of {} and a token of {}", (Object)limit, (Object)continuationToken);
        this.log.debug("CleanupCriteria = {}", (Object)this.policy.getCriteria());
        FluentComponents fluentComponents = ((ContentFacet)this.repository.facet(ContentFacet.class)).components();
        int remainingLimit = limit;
        CompositeComponentSetContinuation<FluentComponent> compositeContinuation = new CompositeComponentSetContinuation<FluentComponent>(continuationToken);
        Map criteria = this.policy.getCriteria();
        boolean selectBySet = criteria.containsKey("sortBy") || criteria.containsKey("retain");
        do {
            CleanupQueryResult processed = selectBySet ? this.processComponentSets(remainingLimit, fluentComponents, compositeContinuation) : this.processComponents(remainingLimit, null, fluentComponents, compositeContinuation);
            remainingLimit = processed.remainingLimit();
            if (processed.hasMore) continue;
            this.log.debug("No more component sets to process");
            compositeContinuation.setComponentSetContinuationToken(null);
            compositeContinuation.setComponentContinuationToken(null);
            break;
        } while (remainingLimit > 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Final result: items={}, remaining={}, setToken={}, componentToken={}, nextToken={}", new Object[]{compositeContinuation.size(), remainingLimit, compositeContinuation.getComponentSetContinuationToken(), compositeContinuation.getComponentContinuationToken(), compositeContinuation.nextContinuationToken()});
        }
        return compositeContinuation;
    }

    CleanupQueryResult processComponentSets(int limit, FluentComponents fluentComponents, CompositeComponentSetContinuation<FluentComponent> compositeContinuation) {
        Continuation componentSets = fluentComponents.sets(limit, compositeContinuation.getComponentSetContinuationToken());
        this.log.debug("Retrieved {} component sets with a limit of {} and a continuation token of {}", new Object[]{componentSets.size(), limit, compositeContinuation.getComponentSetContinuationToken()});
        if (componentSets.isEmpty()) {
            return new CleanupQueryResult(0, false);
        }
        int remainingLimit = limit;
        for (ComponentSetData componentSet : componentSets) {
            CleanupQueryResult result = this.processComponentSet(remainingLimit, componentSet, fluentComponents, compositeContinuation);
            if ((remainingLimit = result.remainingLimit()) <= 0) break;
        }
        return new CleanupQueryResult(remainingLimit, componentSets.size() >= limit || remainingLimit <= 0);
    }

    CleanupQueryResult processComponentSet(int limit, ComponentSetData componentSet, FluentComponents fluentComponents, CompositeComponentSetContinuation<FluentComponent> compositeContinuation) {
        int remainingLimit = limit;
        if (remainingLimit <= 0) {
            return new CleanupQueryResult(remainingLimit, true);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing {}", (Object)componentSet.toStringExternal());
        }
        do {
            CleanupQueryResult processed = this.processComponents(remainingLimit, componentSet, fluentComponents, compositeContinuation);
            remainingLimit = processed.remainingLimit();
            if (processed.hasMore()) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Updating set token to {} and clearing component token", (Object)componentSet.nextContinuationToken());
            }
            compositeContinuation.setComponentSetContinuationToken(componentSet.nextContinuationToken());
            compositeContinuation.setComponentContinuationToken(null);
            break;
        } while (remainingLimit > 0);
        return new CleanupQueryResult(remainingLimit, remainingLimit <= 0);
    }

    CleanupQueryResult processComponents(int limit, ComponentSetData componentSet, FluentComponents fluentComponents, CompositeComponentSetContinuation<FluentComponent> compositeContinuation) {
        String componentToken = compositeContinuation.getComponentContinuationToken();
        CleanupBrowseQuery cleanupBrowseQuery = this.cleanupQueryByFormat.getOrDefault(this.repository.getFormat().getValue(), defaultCleanupQuery);
        Continuation<FluentComponent> components = cleanupBrowseQuery.browse(this.repository, fluentComponents, (ComponentSet)componentSet, this.policy.getCriteria(), this.includeAssets, limit, componentToken);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Retrieved {} components for the set {} with a limit of {} and a token of {}", new Object[]{components.size(), componentSet == null ? null : componentSet.toStringExternal(), limit, componentToken});
        }
        if (components.isEmpty()) {
            this.log.debug("No components found.");
            compositeContinuation.setComponentContinuationToken(null);
            return new CleanupQueryResult(limit, false);
        }
        compositeContinuation.addAll(components);
        String nextComponentToken = components.nextContinuationToken();
        this.log.debug("Updating component token to {}", (Object)nextComponentToken);
        compositeContinuation.setComponentContinuationToken(nextComponentToken);
        int retrieved = components.size();
        int safeRemainingLimit = Math.max(0, limit - retrieved);
        return new CleanupQueryResult(safeRemainingLimit, retrieved >= limit && nextComponentToken != null);
    }

    private static final class CleanupQueryResult {
        private final int remainingLimit;
        private final boolean hasMore;

        CleanupQueryResult(int remainingLimit, boolean hasMore) {
            this.remainingLimit = remainingLimit;
            this.hasMore = hasMore;
        }

        int remainingLimit() {
            return this.remainingLimit;
        }

        boolean hasMore() {
            return this.hasMore;
        }
    }
}

