/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup.internal;

import java.util.Map;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.ComponentSet;
import org.sonatype.nexus.repository.content.SqlQueryParameters;
import org.sonatype.nexus.repository.content.facet.ContentFacet;

public class CleanupBrowseQueryParams
implements SqlQueryParameters {
    private static final String PRERELEASE_CRITERIA = "isPrerelease";
    private static final String LAST_DOWNLODADED_CRITERIA = "lastDownloaded";
    private static final String LAST_BLOB_UPDATED_CRITERIA = "lastBlobUpdated";
    private static final String REGEX_CRITERIA = "regex";
    private static final String RETAIN_CRITERIA = "retain";
    private static final String SORT_BY_CRITERIA = "sortBy";
    private final int repositoryId;
    private final String format;
    private final String name;
    private final String namespace;
    private final boolean includeAssets;
    private final int limit;
    private final String continuationToken;
    private CleanupCriteria cleanupCriteria;
    private RetainCriteria retainCriteria;

    public CleanupBrowseQueryParams(Repository repository, ComponentSet componentSet, Map<String, String> cleanupCriteria, boolean includeAssets, int limit, String continuationToken) {
        this.repositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
        this.format = repository.getFormat().getValue();
        this.name = componentSet != null ? componentSet.name() : null;
        this.namespace = componentSet != null ? componentSet.namespace() : null;
        this.includeAssets = includeAssets;
        this.limit = limit;
        this.continuationToken = continuationToken;
        this.setCleanupCriteria(cleanupCriteria);
        this.setRetainCriteria(cleanupCriteria);
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public String getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean includeAssets() {
        return this.includeAssets;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public CleanupCriteria getCleanupCriteria() {
        return this.cleanupCriteria;
    }

    private void setCleanupCriteria(Map<String, String> criteria) {
        this.cleanupCriteria = new CleanupCriteria(criteria);
    }

    public RetainCriteria getRetainCriteria() {
        return this.retainCriteria;
    }

    private void setRetainCriteria(Map<String, String> criteria) {
        this.retainCriteria = new RetainCriteria(criteria);
    }

    public String toString() {
        return "CleanupBrowseQueryParams{repositoryId=" + this.repositoryId + ", format='" + this.format + '\'' + ", name='" + this.name + '\'' + ", namespace='" + this.namespace + '\'' + ", includeAssets=" + this.includeAssets + ", limit=" + this.limit + ", continuationToken='" + this.continuationToken + '\'' + ", cleanupCriteria=" + this.cleanupCriteria + ", retainCriteria=" + this.retainCriteria + '}';
    }

    public static class CleanupCriteria {
        private final Boolean isPrerelease;
        private final Long lastDownloaded;
        private final Long lastBlobUpdated;
        private final String regex;

        public CleanupCriteria(Map<String, String> criteria) {
            this.isPrerelease = criteria.get(CleanupBrowseQueryParams.PRERELEASE_CRITERIA) != null ? Boolean.valueOf(Boolean.parseBoolean(criteria.get(CleanupBrowseQueryParams.PRERELEASE_CRITERIA))) : null;
            this.lastDownloaded = criteria.get(CleanupBrowseQueryParams.LAST_DOWNLODADED_CRITERIA) != null ? Long.valueOf(Long.parseLong(criteria.get(CleanupBrowseQueryParams.LAST_DOWNLODADED_CRITERIA))) : null;
            this.lastBlobUpdated = criteria.get(CleanupBrowseQueryParams.LAST_BLOB_UPDATED_CRITERIA) != null ? Long.valueOf(Long.parseLong(criteria.get(CleanupBrowseQueryParams.LAST_BLOB_UPDATED_CRITERIA))) : null;
            this.regex = criteria.get(CleanupBrowseQueryParams.REGEX_CRITERIA) != null ? criteria.get(CleanupBrowseQueryParams.REGEX_CRITERIA) : null;
        }

        public Boolean isPrerelease() {
            return this.isPrerelease;
        }

        public Long getLastDownloaded() {
            return this.lastDownloaded;
        }

        public Long getLastBlobUpdated() {
            return this.lastBlobUpdated;
        }

        public String getRegex() {
            return this.regex;
        }

        public boolean hasFilterCriteriaSelected() {
            return this.lastDownloaded != null || this.lastBlobUpdated != null || this.regex != null;
        }

        public String toString() {
            return "CleanupCriteria{isPrerelease=" + this.isPrerelease + ", lastDownloaded=" + this.lastDownloaded + ", lastBlobUpdated=" + this.lastBlobUpdated + ", regex='" + this.regex + '\'' + '}';
        }
    }

    public static class RetainCriteria {
        private final Integer retain;
        private final String sortBy;

        public RetainCriteria(Map<String, String> criteria) {
            this.retain = criteria.get(CleanupBrowseQueryParams.RETAIN_CRITERIA) != null ? Integer.valueOf(Integer.parseInt(criteria.get(CleanupBrowseQueryParams.RETAIN_CRITERIA))) : null;
            this.sortBy = criteria.get(CleanupBrowseQueryParams.SORT_BY_CRITERIA) != null ? criteria.get(CleanupBrowseQueryParams.SORT_BY_CRITERIA) : null;
        }

        public int getRetain() {
            return this.retain;
        }

        public String getSortBy() {
            return this.sortBy;
        }

        public boolean hasRetainCriteriaSelected() {
            return this.retain != null && this.sortBy != null;
        }

        public String toString() {
            return "RetainCriteria{retain=" + this.retain + ", sortBy='" + this.sortBy + '\'' + '}';
        }
    }
}

