/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup.internal;

import com.google.common.collect.ImmutableSet;
import com.sonatype.nexus.cleanup.internal.CleanupBrowseQueryParams;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.jdbc.SQL;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.mybatis.ContinuationArrayList;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.ComponentSet;
import org.sonatype.nexus.repository.content.SqlGenerator;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.fluent.FluentContinuation;

public abstract class CleanupBrowseQuery
extends ComponentSupport
implements SqlGenerator<CleanupBrowseQueryParams> {
    protected String idAttribute = String.valueOf(this.getFormat()) + "_component.component_id";
    protected final Set<String> validCriteria = ImmutableSet.of((Object)"lastDownloaded", (Object)"lastBlobUpdated", (Object)"regex");

    protected Continuation<FluentComponent> browse(Repository repository, FluentComponents fluentComponents, ComponentSet componentSet, Map<String, String> cleanupCriteria, boolean includeAssets, int limit, String continuationToken) {
        block5: {
            block4: {
                if (repository == null) {
                    throw new IllegalArgumentException("Repository must not be null");
                }
                if (cleanupCriteria == null) break block4;
                if (!cleanupCriteria.keySet().stream().noneMatch(this.validCriteria::contains)) break block5;
            }
            return new FluentContinuation((Continuation)new ContinuationArrayList(), arg_0 -> ((FluentComponents)fluentComponents).with(arg_0));
        }
        CleanupBrowseQueryParams params = new CleanupBrowseQueryParams(repository, componentSet, cleanupCriteria, includeAssets, limit, continuationToken);
        return this.doBrowse(fluentComponents, params);
    }

    protected abstract Continuation<FluentComponent> doBrowse(FluentComponents var1, CleanupBrowseQueryParams var2);

    public String generateSelectStatement(CleanupBrowseQueryParams params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("generating sql using params: {}", (Object)params);
        }
        SQL sql = new SQL();
        this.select(sql, params);
        if (this.log.isDebugEnabled()) {
            this.log.debug("generated sql: {}", (Object)sql);
        }
        return sql.toString();
    }

    protected abstract void select(SQL var1, CleanupBrowseQueryParams var2);

    protected abstract String getFormat();
}

