/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup;

import com.sonatype.nexus.cleanup.ProCleanupFeatureCheck;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.content.tasks.normalize.NormalizationPriorityService;

@Singleton
@Priority(value=0x7FFFFFFF)
public class ProNormalizationPriorityService
implements NormalizationPriorityService {
    private final Map<Format, FormatStoreManager> prioritizedFormats = new LinkedHashMap<Format, FormatStoreManager>();

    @Inject
    public ProNormalizationPriorityService(@Nullable ProCleanupFeatureCheck featureCheck, Map<String, FormatStoreManager> managersByFormat, List<Format> formats) {
        Map<Boolean, List<Format>> formatByPriority = formats.stream().collect(Collectors.partitioningBy(format -> featureCheck != null && featureCheck.isRetainSupported(format.getValue())));
        formatByPriority.get(true).forEach(format -> {
            FormatStoreManager formatStoreManager = this.prioritizedFormats.put((Format)format, (FormatStoreManager)managersByFormat.get(format.getValue()));
        });
        formatByPriority.get(false).forEach(format -> {
            FormatStoreManager formatStoreManager = this.prioritizedFormats.put((Format)format, (FormatStoreManager)managersByFormat.get(format.getValue()));
        });
    }

    public Map<Format, FormatStoreManager> getPrioritizedFormats() {
        return this.prioritizedFormats;
    }
}

