/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.cleanup.ProCleanupFeature;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.common.db.DatabaseCheck;
import org.sonatype.nexus.repository.cleanup.CleanupFeatureCheck;
import org.sonatype.nexus.repository.content.kv.global.KeyValueEvent;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;

@Named
@Singleton
public class ProCleanupFeatureCheck
extends ComponentSupport
implements CleanupFeatureCheck {
    private static final String NORMALIZED_STATUS_KEY = ".normalized.version.available";
    private final DatabaseCheck databaseCheck;
    private final Set<String> retainEnabledSet;
    private final boolean useSQL;
    private final LicenseFeatureVerifier licenseVerifier;
    private final ProCleanupFeature proCleanupFeature;
    private final Map<String, FormatStoreManager> formatStoreManagers;
    private final Map<String, Boolean> formatRetainSupportMap;

    @Inject
    public ProCleanupFeatureCheck(DatabaseCheck databaseCheck, LicenseFeatureVerifier licenseVerifier, ProCleanupFeature proCleanupFeature, Map<String, FormatStoreManager> formatStoreManagers, @Named(value="${nexus.cleanup.mavenRetain:-true}") @Named(value="${nexus.cleanup.mavenRetain:-true}") boolean mavenRetainEnabled, @Named(value="${nexus.cleanup.dockerRetain:-true}") @Named(value="${nexus.cleanup.dockerRetain:-true}") boolean dockerRetainEnabled, @Named(value="${nexus.cleanup.useSQL:-true}") @Named(value="${nexus.cleanup.useSQL:-true}") boolean useSQLEnabled) {
        this.databaseCheck = (DatabaseCheck)Preconditions.checkNotNull((Object)databaseCheck);
        this.licenseVerifier = (LicenseFeatureVerifier)Preconditions.checkNotNull((Object)licenseVerifier);
        this.proCleanupFeature = (ProCleanupFeature)((Object)Preconditions.checkNotNull((Object)((Object)proCleanupFeature)));
        this.formatStoreManagers = (Map)Preconditions.checkNotNull(formatStoreManagers);
        this.retainEnabledSet = new HashSet<String>();
        if (mavenRetainEnabled) {
            this.retainEnabledSet.add("maven2");
        }
        if (dockerRetainEnabled) {
            this.retainEnabledSet.add("docker");
        }
        this.useSQL = useSQLEnabled;
        this.formatRetainSupportMap = new HashMap<String, Boolean>(formatStoreManagers.keySet().size());
        this.computeRetainSupportMap();
    }

    public final boolean isRetainSupported(String formatName) {
        return this.formatRetainSupportMap.get(formatName);
    }

    public final boolean isSQLCleanupSupported() {
        return this.useSQL && this.isProVersion() && this.isPostgres();
    }

    public boolean isProVersion() {
        return this.licenseVerifier.verify((Feature)this.proCleanupFeature);
    }

    public boolean isPostgres() {
        return this.databaseCheck.isPostgresql();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(KeyValueEvent event) {
        if (event.getKey().endsWith(NORMALIZED_STATUS_KEY)) {
            this.computeRetainSupportMap();
        }
    }

    private void computeRetainSupportMap() {
        this.formatRetainSupportMap.clear();
        this.formatStoreManagers.keySet().forEach(formatName -> {
            boolean retainEnabled = this.retainEnabledSet.contains(formatName);
            boolean containsOnlyNormalizedVersions = this.formatStoreManagers.get(formatName).componentStore("nexus").browseUnnormalized(1, null).isEmpty();
            boolean retainSupported = this.isProVersion() && this.isPostgres() && retainEnabled && containsOnlyNormalizedVersions;
            this.formatRetainSupportMap.put((String)formatName, retainSupported);
        });
    }
}

