/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.cleanup.ProCleanupFeatureCheck;
import com.sonatype.nexus.cleanup.internal.ComponentSetCleanupBrowser;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.cleanup.content.search.CleanupComponentBrowse;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cleanup.CleanupFeatureCheck;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named(value="ComponentSetCleanupComponentBrowse")
@Singleton
public class ComponentSetCleanupComponentBrowse
implements CleanupComponentBrowse {
    private final CleanupFeatureCheck featureCheck;

    @Inject
    public ComponentSetCleanupComponentBrowse(ProCleanupFeatureCheck featureCheck) {
        this.featureCheck = (CleanupFeatureCheck)Preconditions.checkNotNull((Object)((Object)featureCheck));
    }

    public boolean isApplicableTo(Format format) {
        return this.featureCheck.isRetainSupported(format.getValue()) || this.featureCheck.isSQLCleanupSupported();
    }

    public Stream<FluentComponent> browse(CleanupPolicy policy, Repository repository) {
        Preconditions.checkNotNull((Object)policy);
        Preconditions.checkNotNull((Object)repository);
        return Continuations.streamOf(new ComponentSetCleanupBrowser(repository, policy, false)::browse);
    }

    public Stream<FluentComponent> browseIncludingAssets(CleanupPolicy policy, Repository repository) {
        Preconditions.checkNotNull((Object)policy);
        Preconditions.checkNotNull((Object)repository);
        return Continuations.streamOf(new ComponentSetCleanupBrowser(repository, policy, true)::browse);
    }

    public PagedResponse<Component> browseByPage(CleanupPolicy policy, Repository repository, QueryOptions options) {
        Preconditions.checkNotNull((Object)policy);
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)options.getStart());
        Preconditions.checkNotNull((Object)options.getLimit());
        List result = Continuations.streamOf(new ComponentSetCleanupBrowser(repository, policy, false)::browse, (int)Continuations.BROWSE_LIMIT, (String)options.getLastId()).peek(__ -> {
            boolean bl = CancelableHelper.checkCancellation();
        }).limit(options.getLimit().intValue()).map(Component.class::cast).collect(Collectors.toList());
        return new PagedResponse(-1L, result);
    }
}

