/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.cleanup;

import com.google.common.base.Functions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.cleanup.ProCleanupFeatureCheck;
import com.sonatype.nexus.licensing.ext.LicenseChangedEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.db.DatabaseCheck;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.content.kv.global.GlobalKeyValueStore;
import org.sonatype.nexus.repository.content.kv.global.NexusKeyValue;
import org.sonatype.nexus.repository.content.tasks.normalize.FormatVersionNormalizedEvent;

@FeatureFlag(name="nexus.datastore.enabled")
@Singleton
@Named
public class CleanupRetainStateContributor
extends ComponentSupport
implements StateContributor,
EventAware {
    private final Map<String, String> stateKeyByFormat;
    private final GlobalKeyValueStore globalKeyValueStore;
    private final ProCleanupFeatureCheck featureCheck;
    private final Map<String, Object> state = new HashMap<String, Object>();
    private final DatabaseCheck databaseCheck;

    @Inject
    public CleanupRetainStateContributor(DatabaseCheck databaseCheck, List<Format> formats, GlobalKeyValueStore globalKeyValueStore, @Nullable ProCleanupFeatureCheck featureCheck) {
        this.databaseCheck = databaseCheck;
        this.globalKeyValueStore = globalKeyValueStore;
        this.stateKeyByFormat = this.buildStateKeyByFormat(formats);
        this.featureCheck = featureCheck;
        this.buildStateMap();
    }

    private Map<String, String> buildStateKeyByFormat(List<Format> formats) {
        return formats.stream().collect(Collectors.toMap(Format::getValue, format -> String.format("%s.normalized.version.available", format.getValue())));
    }

    private void buildStateMap() {
        if (this.databaseCheck.isPostgresql()) {
            this.setRetainEnabledFlags();
            this.setNormalizationStateFlags();
        }
    }

    private void setRetainEnabledFlags() {
        this.stateKeyByFormat.keySet().forEach(format -> {
            Object object = this.state.put("nexus.cleanup.{format}Retain".replace("{format}", (CharSequence)format), this.featureCheck != null && this.featureCheck.isRetainSupported((String)format));
        });
    }

    private void setNormalizationStateFlags() {
        Map normalizationStateByFormat = this.stateKeyByFormat.values().stream().collect(Collectors.toMap(Functions.identity(), this::isFormatNormalized));
        this.state.putAll(normalizationStateByFormat);
    }

    private boolean isFormatNormalized(String key) {
        return this.globalKeyValueStore.getKey(key).map(NexusKeyValue::getAsBoolean).orElse(false);
    }

    @Subscribe
    public void on(FormatVersionNormalizedEvent event) {
        this.state.put(this.stateKeyByFormat.get(event.getFormat().getValue()), true);
    }

    @Subscribe
    public void on(LicenseChangedEvent event) {
        this.buildStateMap();
    }

    @Nullable
    public Map<String, Object> getState() {
        return this.state;
    }
}

