/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.supportzip.datastore;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.RestoreHelper;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.RESTORE)
public class SupportRestorer
extends StateGuardLifecycleSupport {
    private final RestoreHelper restoreHelper;
    private final Map<String, ImportData> importDataByName;

    @Inject
    public SupportRestorer(RestoreHelper restoreHelper, Map<String, ImportData> importDataByName) {
        this.restoreHelper = (RestoreHelper)((Object)Preconditions.checkNotNull((Object)((Object)restoreHelper)));
        this.importDataByName = (Map)Preconditions.checkNotNull(importDataByName);
    }

    protected void doStart() throws Exception {
        this.maybeRestore();
    }

    private void maybeRestore() throws IOException {
        Path dbDir = this.restoreHelper.getDbPath();
        for (Map.Entry<String, ImportData> importerEntry : this.importDataByName.entrySet()) {
            String fileName = String.valueOf(importerEntry.getKey()) + ".json";
            File file = dbDir.resolve(fileName).toFile();
            ImportData importer = importerEntry.getValue();
            if (file.exists()) {
                importer.restore(file);
                FileUtils.deleteQuietly((File)file);
                continue;
            }
            this.log.debug("Can't find {} file to restore data", (Object)file);
        }
    }
}

