/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.persist.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.ldap.persist.LdapConfigurationSource;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.internal.orient.OrientLdapConfiguration;
import org.sonatype.nexus.ldap.persist.internal.orient.OrientLdapConfigurationEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientLdapConfigurationSource
extends StateGuardLifecycleSupport
implements LdapConfigurationSource {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientLdapConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientLdapConfigurationSource(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientLdapConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientLdapConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<LdapConfiguration> loadAll() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public String create(LdapConfiguration ldapConfiguration) {
        Preconditions.checkArgument((boolean)(ldapConfiguration instanceof OrientLdapConfiguration), (Object)"Not an instance of OrientLdapConfiguration");
        try {
            return (String)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
                ldapConfiguration.setId(UUID.randomUUID().toString());
                this.entityAdapter.addEntity(db, (Entity)((OrientLdapConfiguration)ldapConfiguration));
                return ldapConfiguration.getId();
            });
        }
        catch (ORecordDuplicatedException e) {
            throw new IllegalArgumentException("Duplicated record: id=" + ldapConfiguration.getId() + ", name=" + ldapConfiguration.getName(), e);
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean update(LdapConfiguration ldapConfiguration) {
        Preconditions.checkArgument((boolean)(ldapConfiguration instanceof OrientLdapConfiguration), (Object)"Not an instance of OrientLdapConfiguration");
        try {
            return (Boolean)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
                ODocument doc = this.entityAdapter.selectById(db, ldapConfiguration.getId());
                if (doc != null) {
                    this.entityAdapter.writeEntity(doc, (Entity)((OrientLdapConfiguration)ldapConfiguration));
                    return true;
                }
                return false;
            });
        }
        catch (OConcurrentModificationException e) {
            throw new IllegalArgumentException("Stale update attempt id=" + ldapConfiguration.getId() + ", name=" + ldapConfiguration.getName(), e);
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean delete(String id) {
        return (Boolean)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
            ODocument doc = this.entityAdapter.selectById(db, id);
            if (doc != null) {
                db.delete((ORecord)doc);
                return true;
            }
            return false;
        });
    }

    @Override
    public LdapConfiguration newConfiguration() {
        return new OrientLdapConfiguration();
    }
}

