/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.persist.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.mybatis.CombUUID;
import org.sonatype.nexus.ldap.persist.LdapConfigurationSource;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.internal.LdapConfigurationDAO;
import org.sonatype.nexus.ldap.persist.internal.LdapConfigurationData;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class LdapConfigurationSourceImpl
extends ConfigStoreSupport<LdapConfigurationDAO>
implements LdapConfigurationSource {
    @Inject
    public LdapConfigurationSourceImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    public LdapConfiguration newConfiguration() {
        return new LdapConfigurationData();
    }

    @Override
    @Transactional
    public List<LdapConfiguration> loadAll() {
        return ImmutableList.copyOf((Iterable)((LdapConfigurationDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public String create(LdapConfiguration ldapConfiguration) {
        ldapConfiguration.setId(CombUUID.combUUID().toString());
        ((LdapConfigurationDAO)this.dao()).create((LdapConfigurationData)ldapConfiguration);
        return ldapConfiguration.getId();
    }

    @Override
    @Transactional
    public boolean update(LdapConfiguration ldapConfiguration) {
        return ((LdapConfigurationDAO)this.dao()).update((LdapConfigurationData)ldapConfiguration);
    }

    @Override
    @Transactional
    public boolean delete(String id) {
        return ((LdapConfigurationDAO)this.dao()).delete(id);
    }
}

