/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.persist.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.ldap.persist.LdapCacheInvalidatedEvent;
import org.sonatype.nexus.ldap.persist.LdapChangeOrderEvent;
import org.sonatype.nexus.ldap.persist.LdapConfigurationCreatedEvent;
import org.sonatype.nexus.ldap.persist.LdapConfigurationDeletedEvent;
import org.sonatype.nexus.ldap.persist.LdapConfigurationEvent;
import org.sonatype.nexus.ldap.persist.LdapConfigurationUpdatedEvent;
import org.sonatype.nexus.ldap.persist.LdapEvent;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;

@Named
@Singleton
public class LdapConfigurationAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "security.ldap";

    public LdapConfigurationAuditor() {
        this.registerType(LdapConfigurationCreatedEvent.class, "created");
        this.registerType(LdapConfigurationDeletedEvent.class, "deleted");
        this.registerType(LdapConfigurationUpdatedEvent.class, "updated");
        this.registerType(LdapChangeOrderEvent.class, "changedOrder");
        this.registerType(LdapCacheInvalidatedEvent.class, "cacheInvalidated");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(LdapEvent event) {
        if (this.isRecording()) {
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(((Object)((Object)event)).getClass()));
            if (event instanceof LdapConfigurationEvent) {
                LdapConfiguration configuration = ((LdapConfigurationEvent)event).getConfiguration();
                data.setContext(configuration.getName());
                Map attributes = data.getAttributes();
                attributes.put("id", configuration.getId());
                attributes.put("name", configuration.getName());
                attributes.put("order", LdapConfigurationAuditor.string((Object)configuration.getOrder()));
            }
            this.record(data);
        }
    }
}

