/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector.dao.password;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.shiro.codec.Base64;
import org.sonatype.nexus.crypto.RandomBytesGenerator;
import org.sonatype.nexus.ldap.internal.connector.dao.password.PasswordEncoder;

public abstract class SaltedDigestPasswordEncoderSupport
implements PasswordEncoder {
    private final HashFunction hashFunction;
    private final String prefix;
    private final int hashLength;
    private RandomBytesGenerator randomBytesGenerator;

    @Inject
    protected SaltedDigestPasswordEncoderSupport(String prefix, HashFunction hashFunction, int hashLength) {
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix);
        this.hashFunction = (HashFunction)Preconditions.checkNotNull((Object)hashFunction);
        Preconditions.checkState((hashLength > 0 ? 1 : 0) != 0);
        this.hashLength = hashLength;
    }

    @Inject
    public final void inject(RandomBytesGenerator randomBytesGenerator) {
        this.randomBytesGenerator = (RandomBytesGenerator)Preconditions.checkNotNull((Object)randomBytesGenerator);
    }

    @Override
    public String encodePassword(String password, Object salt) {
        byte[] saltBytes;
        if (salt == null) {
            saltBytes = new BigInteger(this.randomBytesGenerator.generate(4)).toString(32).getBytes(StandardCharsets.UTF_8);
        } else if (salt instanceof byte[]) {
            saltBytes = (byte[])salt;
        } else {
            throw new IllegalArgumentException("salt must be of type: byte[].");
        }
        Hasher hasher = this.hashFunction.newHasher();
        hasher.putBytes(password.getBytes(StandardCharsets.UTF_8));
        hasher.putBytes(saltBytes);
        byte[] digested = hasher.hash().asBytes();
        byte[] toBeEncoded = new byte[digested.length + saltBytes.length];
        System.arraycopy(digested, 0, toBeEncoded, 0, digested.length);
        System.arraycopy(saltBytes, 0, toBeEncoded, digested.length, saltBytes.length);
        return String.valueOf(this.prefix) + Base64.encodeToString((byte[])toBeEncoded);
    }

    @Override
    public boolean isPasswordValid(String encPassword, String inputPassword, Object salt) {
        byte[] decodedBytes;
        if (inputPassword == null) {
            return false;
        }
        String encryptedPassword = encPassword;
        if (encryptedPassword.startsWith(this.prefix) || encryptedPassword.startsWith(this.prefix.toLowerCase())) {
            encryptedPassword = encryptedPassword.substring(this.prefix.length());
        }
        if ((decodedBytes = Base64.decode((byte[])encryptedPassword.getBytes(StandardCharsets.UTF_8))).length - this.hashLength <= 0) {
            return false;
        }
        byte[] decryptSalt = new byte[decodedBytes.length - this.hashLength];
        System.arraycopy(decodedBytes, this.hashLength, decryptSalt, 0, decryptSalt.length);
        String check = this.encodePassword(inputPassword, decryptSalt);
        return check.substring(this.prefix.length()).equals(encryptedPassword);
    }
}

