/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector.dao.password;

import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.codec.Base64;
import org.sonatype.nexus.ldap.internal.connector.dao.password.PasswordEncoder;

@Singleton
@Named(value="sha")
public class SHA1PasswordEncoder
implements PasswordEncoder {
    @Override
    @Named
    public String getMethod() {
        return "SHA";
    }

    @Override
    @Named
    public String encodePassword(String password, Object salt) {
        return "{SHA}" + this.encodeString(password);
    }

    @Override
    @Named
    public boolean isPasswordValid(String encPassword, String inputPassword, Object salt) {
        String encryptedPassword = encPassword;
        if (encryptedPassword.startsWith("{SHA}") || encryptedPassword.startsWith("{sha}")) {
            encryptedPassword = encryptedPassword.substring("{sha}".length());
        }
        String check = this.encodePassword(inputPassword, salt).substring("{sha}".length());
        return check.equals(encryptedPassword);
    }

    protected String encodeString(String input) {
        ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes());
        String result = null;
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest md = MessageDigest.getInstance("SHA1");
            do {
                if ((numRead = is.read(buffer)) <= 0) continue;
                md.update(buffer, 0, numRead);
            } while (numRead != -1);
            result = Base64.encodeToString((byte[])md.digest());
        }
        catch (Exception exception) {}
        return result;
    }
}

