/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector.dao;

import com.google.common.base.Preconditions;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapAuthConfiguration;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapConnectionTester;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapDAOException;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapGroupDAO;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUser;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUserDAO;
import org.sonatype.nexus.ldap.internal.connector.dao.NoLdapUserRolesFoundException;

@Singleton
@Named
public class DefaultLdapConnectionTester
extends ComponentSupport
implements LdapConnectionTester {
    private final LdapUserDAO ldapUserDao;
    private final LdapGroupDAO ldapGroupDAO;

    @Inject
    public DefaultLdapConnectionTester(LdapUserDAO ldapUserDao, LdapGroupDAO ldapGroupDAO) {
        this.ldapUserDao = (LdapUserDAO)Preconditions.checkNotNull((Object)ldapUserDao);
        this.ldapGroupDAO = (LdapGroupDAO)Preconditions.checkNotNull((Object)ldapGroupDAO);
    }

    @Override
    public void testConnection(LdapContextFactory ldapContextFactory) throws NamingException {
        LdapContext ctx = null;
        try {
            ctx = ldapContextFactory.getSystemLdapContext();
            ctx.getAttributes("");
        }
        catch (Throwable throwable) {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
            throw throwable;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
    }

    @Override
    public SortedSet<LdapUser> testUserAndGroupMapping(LdapContextFactory ldapContextFactory, LdapAuthConfiguration ldapAuthConfiguration, int numberOfResults) throws LdapDAOException, NamingException {
        SortedSet<LdapUser> sortedSet;
        LdapContext ctx = ldapContextFactory.getSystemLdapContext();
        try {
            SortedSet<LdapUser> users = this.ldapUserDao.getAllUsers(ctx, ldapAuthConfiguration, numberOfResults);
            if (ldapAuthConfiguration.isLdapGroupsAsRoles() && Strings2.isEmpty((String)ldapAuthConfiguration.getUserMemberOfAttribute())) {
                for (LdapUser ldapUser : users) {
                    try {
                        ldapUser.setMembership(this.ldapGroupDAO.getGroupMembership(ldapUser.getUsername(), ctx, ldapAuthConfiguration));
                    }
                    catch (NoLdapUserRolesFoundException noLdapUserRolesFoundException) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("While testing for user mapping user: " + ldapUser.getUsername() + " had no roles.");
                    }
                }
            }
            sortedSet = users;
        }
        catch (Throwable throwable) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
            throw throwable;
        }
        try {
            ctx.close();
        }
        catch (NamingException namingException) {}
        return sortedSet;
    }
}

