/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.ldap.model.CreateLdapServerXo;
import org.sonatype.nexus.ldap.model.ReadLdapServerXo;
import org.sonatype.nexus.ldap.model.UpdateLdapServerXo;

@Api(value="Security management: LDAP")
public interface LdapApiResourceDoc {
    @ApiOperation(value="List LDAP servers")
    @ApiResponses(value={@ApiResponse(code=200, message="LDAP server list returned"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public List<ReadLdapServerXo> getLdapServers();

    @ApiOperation(value="Get LDAP server")
    @ApiResponses(value={@ApiResponse(code=200, message="LDAP server returned"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="LDAP server not found")})
    public ReadLdapServerXo getLdapServer(@ApiParam(value="Name of the LDAP server to retrieve") String var1);

    @ApiOperation(value="Delete LDAP server")
    @ApiResponses(value={@ApiResponse(code=204, message="LDAP server deleted"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="LDAP server not found")})
    public void deleteLdapServer(@ApiParam(value="Name of the LDAP server to delete") String var1);

    @ApiOperation(value="Create LDAP server")
    @ApiResponses(value={@ApiResponse(code=201, message="LDAP server created"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public Response createLdapServer(@NotNull @Valid CreateLdapServerXo var1);

    @ApiOperation(value="Update LDAP server")
    @ApiResponses(value={@ApiResponse(code=204, message="LDAP server updated"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="LDAP server not found")})
    public void updateLdapServer(@ApiParam(value="Name of the LDAP server to update") String var1, @ApiParam(value="Updated values of LDAP server") @NotNull @Valid UpdateLdapServerXo var2);

    @ApiOperation(value="Change LDAP server order")
    @ApiResponses(value={@ApiResponse(code=204, message="LDAP server order changed"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public void changeOrder(@ApiParam(value="Ordered list of LDAP server names") @NotNull List<String> var1);
}

