/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.rest;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.sonatype.clm.dto.model.License;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.rhc.RepoHealthCheckComponentDetails;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.HealthCheckResourceService;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.AssetIdentificationService;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.HealthCheckAssetDetailXO;
import com.sonatype.nexus.plugins.healthcheck.service.HdsService;
import com.sonatype.nexus.plugins.healthcheck.service.HttpResult;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.service.SecurityService;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/healthcheck/healthCheckFileDetail")
public class HealthCheckFileDetailResource
implements Resource {
    static final String REST_PREFIX = "/healthcheck/healthCheckFileDetail";
    public static final String COMPONENT_NOT_FOUND = "Vulnerability data is not available for this component. Note that internal components are not covered by Nexus IQ Server.";
    public static final String FORMAT_INVALID = "Vulnerability data is not available for this component. Unknown format.";
    public static final String FORMAT_UNSUPPORTED = "Vulnerability data is not available for this component. Unsupported format: ";
    public static final String LICENSE_REQUIRED = "A paid licence is required";
    public static final String PRIVILEGES_REQUIRED = "Must be logged in to view this content";
    public static final String ERROR_MESSAGE_BASE = "Error accessing server: ";
    private static final String ERROR_COMPONENT_IDENTIFIER_MESSAGE_BASE = "Unable to identify component: ";
    public static final String ERROR_NO_RHC_PRESENT = "This component's containing repository must be analyzed for information to be displayed.";
    private final HdsService hdsService;
    private final SecurityService security;
    private final LicenseService license;
    private final ClmConnector clmConnector;
    private final HealthCheckResourceService healthCheckResourceService;
    private final AssetIdentificationService assetIdentificationService;
    private final RepositoryHealthCheckConfigurationService config;

    @Inject
    public HealthCheckFileDetailResource(HealthCheckResourceService healthCheckResourceService, HdsService hdsService, SecurityService security, LicenseService license, ClmConnector clmConnector, AssetIdentificationService assetIdentificationService, RepositoryHealthCheckConfigurationService config) {
        this.healthCheckResourceService = (HealthCheckResourceService)Preconditions.checkNotNull((Object)healthCheckResourceService);
        this.hdsService = (HdsService)Preconditions.checkNotNull((Object)hdsService);
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
        this.license = (LicenseService)Preconditions.checkNotNull((Object)license);
        this.clmConnector = (ClmConnector)Preconditions.checkNotNull((Object)clmConnector);
        this.assetIdentificationService = (AssetIdentificationService)Preconditions.checkNotNull((Object)assetIdentificationService);
        this.config = (RepositoryHealthCheckConfigurationService)Preconditions.checkNotNull((Object)config);
    }

    @GET
    @Path(value="/{base64Uri}/{base64Repository}/{path:.*}")
    @RequiresPermissions(value={"nexus:healthcheckalerts:read"})
    public Response getComponentDetails(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="base64Uri") String base64Uri, @PathParam(value="path") String path, @PathParam(value="base64Repository") String base64Repository, @QueryParam(value="format") String format) throws Exception {
        String itemPath = Strings2.decodeBase64((String)base64Uri);
        String repositoryName = Strings2.decodeBase64((String)base64Repository);
        response.addHeader("X-Frame-Options", "SAMEORIGIN");
        response.addHeader("X-XSS-Protection", "1; mode=block");
        return this.doGet(request, repositoryName, format, itemPath, path);
    }

    private Response doGet(HttpServletRequest request, String repositoryName, String format, String itemPath, String fullPath) throws Exception {
        if (!this.license.isDetailedReportSupported()) {
            return this.healthCheckResourceService.processError(LICENSE_REQUIRED);
        }
        if (this.security.isAnonymousUser(request)) {
            return this.healthCheckResourceService.processError(PRIVILEGES_REQUIRED);
        }
        String componentFormat = this.getComponentFormat(format);
        if (componentFormat != null && !this.assetIdentificationService.isSupportedFormat(componentFormat)) {
            return this.healthCheckResourceService.processError(FORMAT_UNSUPPORTED + componentFormat);
        }
        if (!this.config.isEnabled(repositoryName) && !this.isConnectedToIQServer()) {
            return this.healthCheckResourceService.processError(ERROR_NO_RHC_PRESENT);
        }
        return this.getContent(repositoryName, componentFormat, itemPath, fullPath);
    }

    private String getComponentFormat(String format) {
        if (format != null && format.startsWith("maven")) {
            return "maven";
        }
        return format;
    }

    private Response getContent(String repositoryName, String format, String itemPath, String path) throws Exception {
        HttpResult result;
        ComponentIdentifier componentIdentifier;
        String hash;
        WebServerService.ContentItem item = this.healthCheckResourceService.getResource(repositoryName, path);
        if (item == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!StringUtils.endsWith((String)item.getFilename(), (String)"index.html")) {
            return Response.ok((Object)item.getBlob().getInputStream(), (String)item.getMediaType()).build();
        }
        if (format == null) {
            return this.healthCheckResourceService.processError(FORMAT_INVALID);
        }
        if (this.isConnectedToIQServer()) {
            return Response.temporaryRedirect((URI)URI.create("healthcheck/clm/assets/version-graph/rm/nexus/index.html")).build();
        }
        try {
            HealthCheckAssetDetailXO xo = this.assetIdentificationService.identify(repositoryName, itemPath);
            hash = xo.getHash();
            componentIdentifier = xo.getComponentIdentifier();
        }
        catch (Exception e) {
            return this.healthCheckResourceService.processError(ERROR_COMPONENT_IDENTIFIER_MESSAGE_BASE + e.getMessage());
        }
        try {
            result = this.hdsService.getComponentDetails(hash, componentIdentifier);
        }
        catch (IOException e) {
            return this.healthCheckResourceService.processError(ERROR_MESSAGE_BASE + e.getMessage());
        }
        try {
            if (!result.isSuccess()) {
                if (404 == result.getStatusCode()) {
                    Response response = this.healthCheckResourceService.processContentNotFound(COMPONENT_NOT_FOUND);
                    return response;
                }
                String errorMessageBody = IOUtils.toString((InputStream)result.getInputStream(), (Charset)result.getContentCharset());
                if (Strings.isNullOrEmpty((String)errorMessageBody)) {
                    Response response = this.healthCheckResourceService.processError(ERROR_MESSAGE_BASE + result.getStatusText());
                    return response;
                }
                Response response = this.healthCheckResourceService.processError(ERROR_MESSAGE_BASE + errorMessageBody);
                return response;
            }
            RepoHealthCheckComponentDetails details = this.hdsService.convertComponentDetails(result);
            Response response = this.healthCheckResourceService.process(item, this.getTemplateModel(details));
            return response;
        }
        finally {
            result.close();
        }
    }

    private boolean isConnectedToIQServer() {
        return this.license.isCLM() && this.clmConnector.isActive() && this.clmConnector.isConfigured();
    }

    private Map<String, Object> getTemplateModel(RepoHealthCheckComponentDetails details) {
        Function<License, String> licenseNameTransformer = new Function<License, String>(){

            @Nullable
            public String apply(License license) {
                return license.getLicenseName();
            }
        };
        Collection declaredLicenseNames = Collections2.transform((Collection)details.getDeclaredLicenses(), (Function)licenseNameTransformer);
        Collection observedLicenseNames = Collections2.transform((Collection)details.getObservedLicenses(), (Function)licenseNameTransformer);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("threatLevelId", details.getLicenseThreatLevelId());
        model.put("threatName", details.getLicenseThreatName());
        model.put("declaredLicenses", declaredLicenseNames);
        model.put("observedLicenses", observedLicenseNames);
        model.put("securityDetails", details.getSecurityVulnerabilities());
        return model;
    }
}

