/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.CLMFeature;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.licensing.product.ProductLicenseManager;
import org.sonatype.licensing.product.util.LicenseFingerprinter;

@Named
@Singleton
public class LicenseServiceImpl
extends ComponentSupport
implements LicenseService {
    static final String INSIGHT_OSS_URL = "https://rhc.sonatype.com/";
    static final String INSIGHT_PRO_URL = "https://rhc-pro.sonatype.com/";
    private final ProductLicenseManager productLicenseManager;
    private final LicenseFingerprinter licenseFingerprinter;

    @Inject
    public LicenseServiceImpl(ProductLicenseManager productLicenseManager, LicenseFingerprinter licenseFingerprinter) {
        this.productLicenseManager = (ProductLicenseManager)Preconditions.checkNotNull((Object)productLicenseManager);
        this.licenseFingerprinter = (LicenseFingerprinter)Preconditions.checkNotNull((Object)licenseFingerprinter);
    }

    public String getDefaultInsightUrl() {
        if (this.isPaidProLicense(this.getLicenseKey())) {
            return INSIGHT_PRO_URL;
        }
        return INSIGHT_OSS_URL;
    }

    public String getLicenseId() {
        ProductLicenseKey key = this.getLicenseKey();
        return key != null ? this.licenseFingerprinter.calculate(key) : null;
    }

    public boolean isCLM() {
        ProductLicenseKey key = this.getLicenseKey();
        return key != null && key.getFeatureSet().hasFeature((Feature)new CLMFeature());
    }

    public boolean isDetailedReportSupported() {
        return this.isPaidProLicense(this.getLicenseKey());
    }

    public boolean isSearchAlertDataSupported() {
        return this.isPaidProLicense(this.getLicenseKey());
    }

    private ProductLicenseKey getLicenseKey() {
        try {
            return this.productLicenseManager.getLicenseDetails();
        }
        catch (LicensingException e) {
            this.log.debug("Failed to determine license key", (Throwable)e);
            return null;
        }
    }

    private boolean isPaidProLicense(ProductLicenseKey key) {
        return key != null && !key.isFreeLicense();
    }
}

