/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.licensing.ext.LicenseChangedEvent;
import com.sonatype.nexus.plugins.healthcheck.service.HdsService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class HealthCheckLicenseListener
extends StateGuardLifecycleSupport {
    private final EventManager eventManager;
    private final HealthCheckTaskManager taskManager;
    private final HdsService hdsService;

    @Inject
    public HealthCheckLicenseListener(EventManager eventManager, HealthCheckTaskManager taskManager, HdsService hdsService) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.taskManager = (HealthCheckTaskManager)Preconditions.checkNotNull((Object)taskManager);
        this.hdsService = (HdsService)Preconditions.checkNotNull((Object)hdsService);
    }

    protected void doStart() {
        this.eventManager.register((Object)this);
    }

    protected void doStop() {
        this.eventManager.unregister((Object)this);
    }

    @Subscribe
    public void licenseChanged(LicenseChangedEvent event) {
        this.hdsService.resetHttpClient();
        try {
            ProductLicenseKey key = event.getLicenseKey();
            if (key != null && !key.isFreeLicense()) {
                this.log.debug("Detected upgrade to Pro license, checking health check scan interval");
                this.taskManager.refreshTaskSchedules();
            }
        }
        catch (LicensingException e) {
            this.log.debug("Failed to determine license key", (Throwable)e);
        }
    }
}

