/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro;

import com.codahale.metrics.annotation.CachedGauge;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.clm.dto.model.repository.FirewallTelemetry;
import com.sonatype.nexus.clm.RepositoryAttributeStorage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class FirewallAnalytics
implements AnalyticsMarker {
    private final RepositoryManager repositoryManager;
    private final RepositoryAttributeStorage repositoryAttributeStorage;

    @Inject
    public FirewallAnalytics(RepositoryManager repositoryManager, RepositoryAttributeStorage repositoryAttributeStorage) {
        this.repositoryManager = repositoryManager;
        this.repositoryAttributeStorage = repositoryAttributeStorage;
    }

    @CachedGauge(name="nexus.analytics.firewall.proxy_repo_counts", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public FirewallTelemetry proxyRepositoryCountsByFormat() {
        FirewallTelemetry firewallTelemetry = new FirewallTelemetry();
        Map<String, List<Repository>> repositoriesByFormat = StreamSupport.stream(this.repositoryManager.browse().spliterator(), true).filter(repository -> repository.getType().getValue().equals("proxy")).collect(Collectors.groupingBy(repository -> repository.getFormat().getValue()));
        firewallTelemetry.proxyRepositoryCountsByFormat = repositoriesByFormat.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.createProxyRepositoryCounts((List)entry.getValue())));
        return firewallTelemetry;
    }

    private FirewallTelemetry.ProxyRepositoryCounts createProxyRepositoryCounts(List<Repository> repositories) {
        Map<Boolean, Long> repositoriesByAuditAndQuarantineCapabilities = repositories.stream().filter(repository -> this.repositoryAttributeStorage.isAuditEnabled(repository.getName())).collect(Collectors.partitioningBy(repository -> this.repositoryAttributeStorage.isQuarantineEnabled(repository.getName()), Collectors.counting()));
        int onlyAuditEnabledCount = repositoriesByAuditAndQuarantineCapabilities.get(false).intValue();
        int auditAndQuarantineEnabledCount = repositoriesByAuditAndQuarantineCapabilities.get(true).intValue();
        FirewallTelemetry.ProxyRepositoryCounts proxyRepositoryCounts = new FirewallTelemetry.ProxyRepositoryCounts();
        proxyRepositoryCounts.count = repositories.size();
        proxyRepositoryCounts.auditEnabledCount = onlyAuditEnabledCount + auditAndQuarantineEnabledCount;
        proxyRepositoryCounts.quarantineEnabledCount = auditAndQuarantineEnabledCount;
        return proxyRepositoryCounts;
    }
}

