/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.cleanup;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.cleanup.AssetPathQuery;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseService;
import org.sonatype.nexus.repository.query.PageResult;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.rest.api.RepositoryItemIDXO;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.internal.AssetContinuationTokenHelper;

@Named
@Singleton
@FeatureFlag(name="nexus.orient.enabled")
public class OrientAssetPathQueryService
implements AssetPathQuery {
    private final BrowseService browseService;
    private final AssetContinuationTokenHelper tokenHelper;

    @Inject
    public OrientAssetPathQueryService(BrowseService browseService, AssetContinuationTokenHelper tokenHelper) {
        this.browseService = (BrowseService)Preconditions.checkNotNull((Object)browseService);
        this.tokenHelper = (AssetContinuationTokenHelper)Preconditions.checkNotNull((Object)tokenHelper);
    }

    @Override
    public Set<String> retrieveAssetPaths(Repository repository) {
        PageResult assetBrowseResult;
        String lastID = null;
        HashSet<String> assetList = new HashSet<String>();
        long assetCount = 0L;
        do {
            assetBrowseResult = this.browseService.browseAssets(repository, new QueryOptions(null, "id", "asc", Integer.valueOf(0), Integer.valueOf(10), lastID));
            for (Asset asset : assetBrowseResult.getResults()) {
                lastID = this.tokenHelper.getIdFromToken(this.tokenHelper.getTokenFromId((Entity)asset));
                assetList.add(new RepositoryItemIDXO(repository.getName(), EntityHelper.id((Entity)asset).getValue()).getValue());
                ++assetCount;
            }
        } while (assetCount < assetBrowseResult.getTotal());
        return new HashSet<String>(assetList);
    }
}

