/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.cleanup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.component.RepositoryComponentPathnames;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.internal.cleanup.AssetPathQuery;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.DeploymentAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="internal/clm/cleanup/")
public class ClmCleanupResource
extends ComponentSupport
implements Resource {
    static final String RESOURCE_URI = "internal/clm/cleanup/";
    private static final int UNPROCESSABLE_ENTITY = 422;
    private final RepositoryManager repositoryManager;
    private final ClmConnector clmConnector;
    private final LicenseService license;
    private final DeploymentAccess deploymentAccess;
    private final AssetPathQuery assetPathQuery;
    private final AtomicBoolean cleanupRequested = new AtomicBoolean(false);
    private final ObjectWriter objectWriter = new ObjectMapper().writerFor(RepositoryComponentPathnames.class);

    @Inject
    public ClmCleanupResource(RepositoryManager repositoryManager, ClmConnector clmConnector, LicenseService license, DeploymentAccess deploymentAccess, AssetPathQuery assetPathQuery) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.clmConnector = (ClmConnector)Preconditions.checkNotNull((Object)clmConnector);
        this.license = (LicenseService)Preconditions.checkNotNull((Object)license);
        this.deploymentAccess = (DeploymentAccess)Preconditions.checkNotNull((Object)deploymentAccess);
        this.assetPathQuery = (AssetPathQuery)Preconditions.checkNotNull((Object)assetPathQuery);
    }

    @GET
    @RequiresAuthentication
    @Path(value="{repositoryName}")
    public void cleanup(@PathParam(value="repositoryName") String repositoryName) {
        this.checkIqLicense();
        Repository repository = this.getValidRepository(repositoryName);
        try {
            if (!this.cleanupRequested.compareAndSet(false, true)) {
                Response response = Response.status((int)429).header("Retry-After", (Object)300).entity((Object)"IQ Cleanup request already in progress").build();
                throw new WebApplicationException(response);
            }
            Set<String> assetPaths = this.assetPathQuery.retrieveAssetPaths(repository);
            this.log.info("IQ Cleanup: Found {} assets for repository {}", (Object)assetPaths.size(), (Object)repositoryName);
            this.sendAssetPathsToIQ(repositoryName, assetPaths);
        }
        finally {
            this.cleanupRequested.set(false);
        }
    }

    private void checkIqLicense() {
        if (!this.license.isCLM()) {
            throw new WebApplicationException("IQ Server license is required.", Response.Status.PAYMENT_REQUIRED);
        }
        if (!this.clmConnector.isActive() || !this.clmConnector.isConfigured()) {
            throw new WebApplicationException("IQ Server has not been configured.", Response.Status.CONFLICT);
        }
    }

    private Repository getValidRepository(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new WebApplicationException(String.format("Repository %s not found", repositoryName), Response.Status.NOT_FOUND);
        }
        if (!"proxy".equals(repository.getType().getValue())) {
            throw new WebApplicationException(String.format("Repository %s is not a Proxy repository", repositoryName), 422);
        }
        if (!"npm".equals(repository.getFormat().getValue())) {
            throw new WebApplicationException(String.format("Repository %s is not an NPM repository", repositoryName), 422);
        }
        return repository;
    }

    private void sendAssetPathsToIQ(String repositoryName, Set<String> assetNames) {
        RepositoryComponentPathnames pathnames = new RepositoryComponentPathnames();
        pathnames.time = new Date();
        pathnames.pathnames = assetNames;
        HttpPost request = this.buildIqQuery(repositoryName, pathnames);
        this.sendIqData(request);
    }

    @VisibleForTesting
    HttpPost buildIqQuery(String repositoryName, RepositoryComponentPathnames pathnames) {
        EntityBuilder builder;
        HttpPost request;
        block2: {
            String url = String.format("%s/rest/integration/repositories/%s/%s/removeExtraComponents", this.getIqServerURL(), this.deploymentAccess.getId(), repositoryName);
            request = new HttpPost(url);
            builder = EntityBuilder.create();
            try {
                builder.setText(this.objectWriter.writeValueAsString((Object)pathnames));
            }
            catch (Exception ex) {
                this.log.error("Unable to serialize asset paths for IQ cleanup: {}", (Object)ex.getLocalizedMessage());
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("Stack Trace:", (Throwable)ex);
            }
        }
        builder.setContentType(ContentType.APPLICATION_JSON);
        request.setEntity(builder.build());
        return request;
    }

    @VisibleForTesting
    String getIqServerURL() {
        return this.clmConnector.getRestConfiguration().getServerUrl();
    }

    @VisibleForTesting
    void sendIqData(HttpPost request) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpClient client = this.clmConnector.createHttpClientBuilder().build();){
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 204) {
                    this.log.error("IQ Cleanup outbound request to {} failed {}: {}", new Object[]{request.getRequestLine(), statusCode, response.getStatusLine().getReasonPhrase()});
                    throw new WebApplicationException("IQ Cleanup outbound request failed. Please check the system logs.", Response.Status.BAD_GATEWAY);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.log.error("IQ Cleanup outbound request to {} failed: {}", (Object)request.getRequestLine(), (Object)ex.getLocalizedMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stack Trace:", (Throwable)ex);
            }
            throw new WebApplicationException("IQ Cleanup outbound request failed. Please check the system logs.", Response.Status.BAD_GATEWAY);
        }
    }
}

