/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.cleanup;

import com.sonatype.nexus.clm.internal.cleanup.AssetPathQuery;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.store.AssetData;
import org.sonatype.nexus.repository.content.store.WrappedContent;

@Named
@Singleton
@FeatureFlag(name="nexus.datastore.enabled")
public class AssetPathQueryService
implements AssetPathQuery {
    @Override
    public Set<String> retrieveAssetPaths(Repository repository) {
        return Continuations.streamOf((arg_0, arg_1) -> ((FluentAssets)((ContentFacet)repository.facet(ContentFacet.class)).assets()).browse(arg_0, arg_1)).map(this::assetPath).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Optional<String> assetPath(Asset asset) {
        return Optional.ofNullable(((AssetData)this.unwrap((RepositoryContent)asset)).path());
    }

    private RepositoryContent unwrap(RepositoryContent content) {
        return content instanceof WrappedContent ? ((WrappedContent)content).unwrap() : content;
    }
}

