/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.features.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.karaf.util.maven.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationResolver {
    private static final Logger log = LoggerFactory.getLogger(LocationResolver.class);
    private final File systemDir = new File("system");
    private final File mavenDir = !"false".equalsIgnoreCase(System.getProperty("nexus.testLocalSnapshots", "false")) ? LocationResolver.mavenDir(this.systemDir) : null;

    public String resolve(String location) {
        String result = location;
        try {
            int mvn = location.indexOf("mvn:");
            if (mvn == 0) {
                result = this.resolveMavenPath(location);
            } else if (mvn > 0) {
                String prefix = location.substring(0, mvn);
                int flags = location.indexOf(36);
                if (flags < 0) {
                    result = String.valueOf(prefix) + this.resolveMavenPath(location.substring(mvn));
                } else {
                    String suffix = location.substring(flags, location.length());
                    result = String.valueOf(prefix) + this.resolveMavenPath(location.substring(mvn, flags)) + suffix;
                }
            }
        }
        catch (MalformedURLException e) {
            log.warn("Malformed location {}", (Object)location, (Object)e);
        }
        if (result.startsWith("file:")) {
            result = "reference:" + result;
        }
        log.debug("Resolved {} to {}", (Object)location, (Object)result);
        return result;
    }

    private String resolveMavenPath(String mvnPath) throws MalformedURLException {
        String repositoryPath = Parser.pathFromMaven(mvnPath);
        if (this.mavenDir != null && repositoryPath.contains("SNAPSHOT") && new File(this.mavenDir, repositoryPath).canRead()) {
            return this.mavenDir.toURI() + repositoryPath;
        }
        if (new File(this.systemDir, repositoryPath).canRead()) {
            return "file:system/" + repositoryPath;
        }
        return mvnPath;
    }

    private static File mavenDir(File systemDir) {
        String localRepository;
        block5: {
            localRepository = System.getProperty("maven.repo.local", System.getProperty("localRepository", ""));
            if (!localRepository.isEmpty()) break block5;
            Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
            if (userHome.isAbsolute() && Files.isDirectory(userHome, new LinkOption[0])) {
                localRepository = userHome.resolve(".m2").resolve("repository").toString();
                break block5;
            }
            return null;
        }
        try {
            File mavenDir = localRepository.startsWith("file:") ? new File(URI.create(localRepository)) : new File(localRepository);
            if (mavenDir.isDirectory() && !Files.isSameFile(mavenDir.toPath(), systemDir.toPath())) {
                log.info("Using local maven repository '{}' for testing snapshots", (Object)mavenDir);
                return mavenDir;
            }
        }
        catch (IOException | RuntimeException e) {
            log.debug("Cannot locate local maven repository for testing snapshots", (Throwable)e);
        }
        return null;
    }
}

