/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.features.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureState;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.features.internal.FeaturesResolver;
import org.sonatype.nexus.features.internal.LocationResolver;

public class FeaturesWrapper
extends ServiceTracker<FeaturesService, FeaturesService>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(FeaturesWrapper.class);
    private static final Dictionary<String, ?> MAX_RANKING = new Hashtable<String, Integer>(Collections.singletonMap("service.ranking", Integer.MAX_VALUE));
    private final FeaturesService wrapper = (FeaturesService)Proxy.newProxyInstance(FeaturesService.class.getClassLoader(), new Class[]{FeaturesService.class}, (InvocationHandler)this);
    private volatile FeaturesService delegate;
    private ServiceRegistration<FeaturesService> trampoline;
    private volatile LocationResolver locationResolver;
    private volatile FeaturesResolver featuresResolver;

    public FeaturesWrapper(BundleContext context) {
        super(context, FeaturesService.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeaturesService addingService(ServiceReference<FeaturesService> reference) {
        if (this.delegate == null) {
            FeaturesService featuresService = this.wrapper;
            synchronized (featuresService) {
                if (this.delegate == null) {
                    log.info("Fast FeaturesService starting");
                    this.delegate = (FeaturesService)super.addingService(reference);
                    this.trampoline = this.context.registerService(FeaturesService.class, (Object)this.wrapper, MAX_RANKING);
                }
            }
            return this.delegate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<FeaturesService> reference, FeaturesService service) {
        if (this.delegate == service) {
            FeaturesService featuresService = this.wrapper;
            synchronized (featuresService) {
                if (this.delegate == service) {
                    log.info("Fast FeaturesService stopping");
                    this.trampoline.unregister();
                    super.removedService(reference, (Object)service);
                    this.locationResolver = null;
                    this.featuresResolver = null;
                    this.delegate = null;
                }
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("installFeature")) {
            return this.fastInstallFeature(method, args);
        }
        if (methodName.startsWith("uninstallFeature")) {
            log.info("uninstalling is not supported in 'fastFeatures' mode");
            return null;
        }
        if ("listInstalledFeatures".equals(methodName)) {
            return this.listInstalledFeatures();
        }
        if ("isInstalled".equals(methodName)) {
            return this.isInstalled((Feature)args[0]);
        }
        if ("getState".equals(methodName)) {
            return this.getState((String)args[0]);
        }
        try {
            return method.invoke((Object)this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause() != null ? e.getCause() : e;
        }
    }

    private Void fastInstallFeature(Method method, Object[] args) throws Exception {
        Stream<BundleInfo> bundles;
        String signature;
        switch (signature = Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(", "))) {
            case "java.lang.String, java.util.EnumSet": 
            case "java.lang.String": {
                bundles = this.featuresResolver().resolve((String)args[0]);
                break;
            }
            case "java.lang.String, java.lang.String, java.util.EnumSet": 
            case "java.lang.String, java.lang.String": {
                bundles = this.featuresResolver().resolve(args[0] + "/" + args[1]);
                break;
            }
            case "org.apache.karaf.features.Feature, java.util.EnumSet": {
                bundles = this.featuresResolver().resolve((Feature)args[0]);
                break;
            }
            case "java.util.Set, java.util.EnumSet": 
            case "java.util.Set, java.lang.String, java.util.EnumSet": {
                bundles = this.featuresResolver().resolve((Set)args[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected method: " + method);
            }
        }
        bundles.map(this::installBundle).filter(Objects::nonNull).collect(Collectors.toList()).forEach(this::startBundle);
        return null;
    }

    public Feature[] listInstalledFeatures() throws Exception {
        return (Feature[])Arrays.stream(this.delegate.listFeatures()).filter(this::isInstalled).toArray(Feature[]::new);
    }

    public boolean isInstalled(Feature feature) {
        return this.featuresResolver().isInstalled(feature.getId());
    }

    public FeatureState getState(String featureId) {
        if (this.featuresResolver().isInstalled(featureId)) {
            return FeatureState.Installed;
        }
        return this.delegate.getState(featureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeaturesResolver featuresResolver() {
        if (this.featuresResolver == null) {
            FeaturesService featuresService = this.wrapper;
            synchronized (featuresService) {
                if (this.featuresResolver == null) {
                    this.locationResolver = new LocationResolver();
                    this.featuresResolver = new FeaturesResolver(this.delegate);
                }
            }
        }
        return this.featuresResolver;
    }

    private Bundle installBundle(BundleInfo info) {
        block5: {
            try {
                String location = this.locationResolver.resolve(info.getLocation());
                if (this.context.getBundle(location) == null) {
                    log.debug("Installing {}", (Object)location);
                    Bundle bundle = this.context.installBundle(location);
                    log.debug("Installed {}/{} from {}", new Object[]{bundle.getSymbolicName(), bundle.getVersion(), location});
                    if (info.getStartLevel() > 0) {
                        ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(info.getStartLevel());
                    }
                    if (info.isStart() && bundle.getHeaders().get("Fragment-Host") == null) {
                        return bundle;
                    }
                }
            }
            catch (BundleException e) {
                if (e.getType() == 9) break block5;
                log.warn("Problem installing {}", (Object)info.getLocation(), (Object)e);
            }
        }
        return null;
    }

    private void startBundle(Bundle bundle) {
        if ((bundle.getState() & 6) != 0) {
            try {
                log.debug("Starting {}/{}", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
                bundle.start();
                log.debug("Started {}/{}", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
            }
            catch (BundleException e) {
                log.warn("Problem starting {}", (Object)bundle.getLocation(), (Object)e);
            }
        }
    }
}

