/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.features.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesResolver {
    private static final Logger log = LoggerFactory.getLogger(FeaturesResolver.class);
    private static final String VERSION_WILDCARD = "/0.0.0";
    private final Map<String, Feature> featuresById = new HashMap<String, Feature>();
    private final Set<String> installedFeatures = Collections.synchronizedSet(new HashSet());
    private final Set<String> excludedFeatures = FeaturesResolver.findExcludedFeatures();

    public FeaturesResolver(FeaturesService delegate) {
        try {
            Feature[] featureArray = delegate.listFeatures();
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Feature f = featureArray[n2];
                this.featuresById.putIfAbsent(f.getId(), f);
                this.featuresById.putIfAbsent(String.valueOf(f.getName()) + VERSION_WILDCARD, f);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem listing available features", e);
        }
    }

    public Stream<BundleInfo> resolve(Set<String> names) {
        return names.stream().flatMap(this::resolve);
    }

    public Stream<BundleInfo> resolve(String id) {
        Feature feature = this.featuresById.get(FeaturesResolver.normalize(id));
        if (feature != null) {
            return this.resolve(feature);
        }
        log.warn("Missing feature {}", (Object)id);
        return Stream.of(new BundleInfo[0]);
    }

    public Stream<BundleInfo> resolve(Feature feature) {
        if (feature != null) {
            String id = feature.getId();
            if (this.excludedFeatures.contains(id) || this.excludedFeatures.contains(feature.getName())) {
                log.info("Excluding feature {}", (Object)id);
            } else if (this.installedFeatures.add(id)) {
                log.debug("Resolving feature {}", (Object)id);
                return Stream.concat(feature.getDependencies().stream().flatMap(d -> this.resolve(String.valueOf(d.getName()) + '/' + d.getVersion())), feature.getBundles().stream());
            }
        }
        return Stream.of(new BundleInfo[0]);
    }

    public boolean isInstalled(String id) {
        return this.installedFeatures.contains(FeaturesResolver.normalize(id));
    }

    private static String normalize(String id) {
        return id.indexOf(47) < 0 ? String.valueOf(id) + VERSION_WILDCARD : id;
    }

    private static Set<String> findExcludedFeatures() {
        String excludedFeatures = System.getProperty("nexus-exclude-features", "");
        return new HashSet<String>(Arrays.asList(excludedFeatures.split("[\\s,]+")));
    }
}

