/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.raw;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.raw.RawAttributes;
import org.sonatype.nexus.repository.raw.RawHostedApiRepository;
import org.sonatype.nexus.repository.raw.RawProxyApiRepository;
import org.sonatype.nexus.repository.rest.api.SimpleApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named(value="raw")
public class RawRepositoryAdapter
extends SimpleApiRepositoryAdapter {
    private static final String RAW = "raw";

    @Inject
    public RawRepositoryAdapter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public AbstractApiRepository adapt(Repository repository) {
        switch (repository.getType().toString()) {
            case "hosted": {
                return new RawHostedApiRepository(repository.getName(), repository.getUrl(), repository.getConfiguration().isOnline(), this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getComponentAttributes(repository), this.createRawAttributes(repository));
            }
            case "proxy": {
                return new RawProxyApiRepository(repository.getName(), repository.getUrl(), repository.getConfiguration().isOnline(), (StorageAttributes)this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getProxyAttributes(repository), this.getNegativeCacheAttributes(repository), this.getHttpClientAttributes(repository), this.getRoutingRuleName(repository), this.getReplicationAttributes(repository), this.createRawAttributes(repository));
            }
        }
        return super.adapt(repository);
    }

    private RawAttributes createRawAttributes(Repository repository) {
        String disposition = (String)repository.getConfiguration().attributes(RAW).get("contentDisposition", String.class);
        return new RawAttributes(disposition);
    }
}

