/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.raw.internal;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.inject.Named;
import org.sonatype.nexus.common.template.EscapeHelper;
import org.sonatype.nexus.orient.raw.RawContentFacet;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
public class RawProxyFacet
extends ProxyFacetSupport {
    private static final ImmutableSet<String> CHARS_TO_ENCODE = ImmutableSet.of((Object)"^", (Object)"#", (Object)"?");

    protected Content getCachedContent(Context context) throws IOException {
        String path = this.componentPath(context);
        return this.content().get(path);
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.content().setCacheInfo(this.componentPath(context), content, cacheInfo);
    }

    protected Content store(Context context, Content payload) throws IOException {
        String path = this.componentPath(context);
        return this.content().put(path, (Payload)payload);
    }

    protected String getUrl(@Nonnull Context context) {
        return new EscapeHelper().uriSegments(this.componentPath(context));
    }

    protected String encodeUrl(String url) throws UnsupportedEncodingException {
        String encodedUrl = url;
        for (String ch : CHARS_TO_ENCODE) {
            encodedUrl = encodedUrl.replace(ch, URLEncoder.encode(ch, "UTF-8"));
        }
        return encodedUrl;
    }

    private String componentPath(Context context) {
        TokenMatcher.State tokenMatcherState = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        return (String)tokenMatcherState.getTokens().get("name");
    }

    private RawContentFacet content() {
        return (RawContentFacet)this.getRepository().facet(RawContentFacet.class);
    }
}

