/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.raw.internal.recipe;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.content.raw.RawContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class RawContentHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String path = this.contentPath(context);
        String method = context.getRequest().getAction();
        Repository repository = context.getRepository();
        this.log.debug("{} repository '{}' content-path: {}", new Object[]{method, repository.getName(), path});
        RawContentFacet storage = (RawContentFacet)repository.facet(RawContentFacet.class);
        switch (method) {
            case "GET": 
            case "HEAD": {
                return storage.get(path).map(HttpResponses::ok).orElseGet(() -> HttpResponses.notFound((String)path));
            }
            case "PUT": {
                Payload content = context.getRequest().getPayload();
                storage.put(path, content);
                return HttpResponses.created();
            }
            case "DELETE": {
                boolean deleted = storage.delete(path);
                if (deleted) {
                    return HttpResponses.noContent();
                }
                return HttpResponses.notFound((String)path);
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD", "PUT", "DELETE"});
    }

    @Nonnull
    private String contentPath(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = (String)state.getTokens().get("path");
        Preconditions.checkState((path != null ? 1 : 0) != 0, (Object)"Missing token: path");
        return path;
    }
}

