/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.crypto.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.crypto.internal.PasswordCipher;
import org.sonatype.nexus.crypto.maven.MavenCipher;

@Named
@Singleton
public class MavenCipherImpl
implements MavenCipher {
    private static final char SHIELD_BEGIN = '{';
    private static final char SHIELD_END = '}';
    private static final CharMatcher BEGIN_MATCHER = CharMatcher.is((char)'{');
    private static final CharMatcher END_MATCHER = CharMatcher.is((char)'}');
    private static final int MIN_PAYLOAD_LENGTH = 32;
    private static final Pattern BASE_64_REGEX = Pattern.compile("[A-Za-z0-9+/]*={0,2}");
    private final PasswordCipher passwordCipher;

    @Inject
    public MavenCipherImpl(CryptoHelper cryptoHelper) {
        this.passwordCipher = new PasswordCipher(cryptoHelper);
    }

    @Override
    public String encrypt(CharSequence str, String passPhrase) {
        Preconditions.checkNotNull((Object)str);
        Preconditions.checkNotNull((Object)passPhrase);
        return String.valueOf('{') + this.doEncrypt(str, passPhrase) + '}';
    }

    private String doEncrypt(CharSequence str, String passPhrase) {
        return new String(this.passwordCipher.encrypt(MavenCipherImpl.getBytesUTF8(str), passPhrase), StandardCharsets.UTF_8);
    }

    @Override
    public String decrypt(String str, String passPhrase) {
        Preconditions.checkNotNull((Object)str);
        Preconditions.checkNotNull((Object)passPhrase);
        return this.doDecrypt(MavenCipherImpl.peel(str), passPhrase).toString();
    }

    @Override
    public char[] decryptChars(String str, String passPhrase) {
        Preconditions.checkNotNull((Object)str);
        Preconditions.checkNotNull((Object)passPhrase);
        CharBuffer charBuffer = this.doDecrypt(MavenCipherImpl.peel(str), passPhrase);
        char[] chars = new char[charBuffer.remaining()];
        charBuffer.get(chars);
        return chars;
    }

    private CharBuffer doDecrypt(CharSequence str, String passPhrase) {
        Preconditions.checkArgument((str != null ? 1 : 0) != 0, (Object)"Input string is not a password cipher");
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(this.passwordCipher.decrypt(MavenCipherImpl.getBytesUTF8(str), passPhrase)));
    }

    @Override
    public boolean isPasswordCipher(CharSequence str) {
        return MavenCipherImpl.peel(str) != null;
    }

    @Nullable
    private static CharSequence peel(CharSequence str) {
        int stop;
        int payloadLength;
        if (str == null || str.length() == 0) {
            return null;
        }
        int start = BEGIN_MATCHER.indexIn(str) + 1;
        if (start > 0 && (payloadLength = (stop = END_MATCHER.lastIndexIn(str)) - start) >= 32 && payloadLength % 4 == 0 && BASE_64_REGEX.matcher(str).region(start, stop).matches()) {
            return str.subSequence(start, stop);
        }
        return null;
    }

    private static byte[] getBytesUTF8(CharSequence str) {
        if (str instanceof String) {
            return ((String)str).getBytes(StandardCharsets.UTF_8);
        }
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(str));
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return bytes;
    }
}

