/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.vulnerability.Log4JVisualizerManager;
import com.sonatype.nexus.vulnerability.internal.rest.ApiLog4JVisualizerConfiguration;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.validation.Validate;

@Produces(value={"application/json"})
public class Log4JVisualizerApiResource
implements Resource {
    private final Log4JVisualizerManager manager;

    @Inject
    public Log4JVisualizerApiResource(Log4JVisualizerManager legalDisclaimerManager) {
        this.manager = (Log4JVisualizerManager)Preconditions.checkNotNull((Object)legalDisclaimerManager);
    }

    @GET
    @RequiresPermissions(value={"nexus:*"})
    public ApiLog4JVisualizerConfiguration getLegalDisclaimerConfiguration() {
        return new ApiLog4JVisualizerConfiguration(this.manager.isLog4JVisualizerEnabled());
    }

    @POST
    @Validate
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void setLegalDisclaimerConfiguration(@Valid ApiLog4JVisualizerConfiguration configuration) {
        this.manager.setLog4JVisualizerEnabled(configuration.isEnabled(), true);
    }
}

