/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.sonatype.nexus.vulnerability.internal.legal.ProxyDownloadStore;
import com.sonatype.nexus.vulnerability.internal.orient.OrientProxyDownloadEntityAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.rest.api.RepositoryXO;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientProxyDownloadStore
extends StateGuardLifecycleSupport
implements ProxyDownloadStore {
    private static final int DOWNLOADS_DURING_LAST_N_DAYS = 90;
    public static final String REPOSITORY_TYPE = "proxy";
    public static final List<String> REPOSITORY_FORMATS = ImmutableList.of((Object)"maven2", (Object)"pypi", (Object)"npm");
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientProxyDownloadEntityAdapter entityAdapter;
    private final RepositoryManagerRESTAdapter repoAdapter;

    @Inject
    public OrientProxyDownloadStore(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> databaseInstance, OrientProxyDownloadEntityAdapter entityAdapter, RepositoryManagerRESTAdapter repoAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientProxyDownloadEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.repoAdapter = repoAdapter;
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getProxyDownloadNumbers() {
        List collect = this.repoAdapter.getRepositories().stream().filter(x -> REPOSITORY_FORMATS.contains(x.getFormat())).filter(x -> REPOSITORY_TYPE.equals(x.getType())).collect(Collectors.toList());
        HashMap<String, Long> totalNumbers = new HashMap<String, Long>();
        for (RepositoryXO repo : collect) {
            Repository repository = this.repoAdapter.getRepository(repo.getName());
            Long prevValue = totalNumbers.getOrDefault(repository.getFormat().getValue(), 0L);
            totalNumbers.put(repository.getFormat().getValue(), prevValue + this.getNumberOfDownloadsInLastNDays(repository, 90L));
        }
        return this.getUrlWithNumbersOfDownloads(totalNumbers);
    }

    public Long getNumberOfDownloadsInLastNDays(Repository repository, long days) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkState((days >= 0L ? 1 : 0) != 0);
        return (Long)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getProxyDownloads(db, repository, days).longValue());
    }

    private String getUrlWithNumbersOfDownloads(Map<String, Long> totalNumbers) {
        if (totalNumbers.isEmpty()) {
            return "";
        }
        String result = totalNumbers.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + e.getValue()).collect(Collectors.joining("&"));
        return "&" + result;
    }
}

