/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.orient;

import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.sonatype.nexus.vulnerability.internal.orient.OrientCoordinateDownload;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.repository.Repository;

@Named
@Singleton
public class OrientProxyDownloadEntityAdapter
extends IterableEntityAdapter<AbstractEntity> {
    private static final String DB_CLASS = new OClassNameBuilder().type("number_of_proxy_downloads").build();
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String P_LAST_UPDATED = "last_updated";
    private static final String P_NUMBER_OF_DOWNLOADS = "number_of_downloads";

    @Inject
    public OrientProxyDownloadEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
    }

    protected OrientCoordinateDownload newEntity() {
        return new OrientCoordinateDownload();
    }

    protected void readFields(ODocument document, AbstractEntity entity) {
    }

    protected void writeFields(ODocument document, AbstractEntity entity) {
    }

    Integer getProxyDownloads(ODatabaseDocumentTx db, Repository repository, long days) {
        String query = OrientProxyDownloadEntityAdapter.createQuery();
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{OrientProxyDownloadEntityAdapter.buildQueryParameters(repository.getName(), days)});
        return Optional.ofNullable((ODocument)Iterables.getFirst((Iterable)docs, null)).map(doc -> (Integer)doc.field(P_NUMBER_OF_DOWNLOADS, Integer.class)).orElse(null);
    }

    private static Map<String, Object> buildQueryParameters(String repositoryName, Long days) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (repositoryName != null) {
            params.put("repositoryName", repositoryName);
        }
        if (days != null) {
            params.put("lastUpdated", OrientProxyDownloadEntityAdapter.dateAsString(LocalDate.now().minusDays(days)));
        }
        return params;
    }

    private static String createQuery() {
        return String.format("SELECT count(*) AS number_of_downloads FROM component WHERE bucket IN (SELECT @RID FROM bucket WHERE %s=:repositoryName LIMIT 1) AND %s>:lastUpdated", P_REPOSITORY_NAME, P_LAST_UPDATED);
    }

    private static String dateAsString(LocalDate localDate) {
        return localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }
}

