/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.sonatype.nexus.vulnerability.internal.legal.Log4JVisualizerConfigurationStore;
import com.sonatype.nexus.vulnerability.internal.orient.OrientLog4JVisualizerConfiguration;
import com.sonatype.nexus.vulnerability.internal.orient.OrientLog4JVisualizerConfigurationEntityAdapter;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientLog4JVisualizerConfigurationStore
extends StateGuardLifecycleSupport
implements Log4JVisualizerConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientLog4JVisualizerConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientLog4JVisualizerConfigurationStore(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientLog4JVisualizerConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientLog4JVisualizerConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public Optional<Boolean> isEnabled() {
        OrientLog4JVisualizerConfiguration config = (OrientLog4JVisualizerConfiguration)OrientTransactional.inTx(this.databaseInstance).call(arg_0 -> ((OrientLog4JVisualizerConfigurationEntityAdapter)this.entityAdapter).get(arg_0));
        if (config == null) {
            return Optional.empty();
        }
        return Optional.of(config.isEnabled());
    }

    @Override
    @Guarded(by={"STARTED"})
    public void setEnabled(boolean enabled) {
        OrientLog4JVisualizerConfiguration config = new OrientLog4JVisualizerConfiguration(enabled);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.set(db, (Entity)config);
        });
    }
}

