/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.log;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.vulnerability.Log4JVisualizerManager;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class VulnerabilityStatisticsTaskManager
extends StateGuardLifecycleSupport {
    private final TaskScheduler taskScheduler;
    private final String vulnerabilityStatisticsCron;
    private final Log4JVisualizerManager log4JVisualizerManager;

    @Inject
    public VulnerabilityStatisticsTaskManager(TaskScheduler taskScheduler, @Named(value="${nexus.vulnerabilityStatistics.cron:-0 4 0 * * ?}") @Named(value="${nexus.vulnerabilityStatistics.cron:-0 4 0 * * ?}") String vulnerabilityStatisticsCron, Log4JVisualizerManager log4JVisualizerManager) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.vulnerabilityStatisticsCron = (String)Preconditions.checkNotNull((Object)vulnerabilityStatisticsCron);
        this.log4JVisualizerManager = (Log4JVisualizerManager)Preconditions.checkNotNull((Object)log4JVisualizerManager);
    }

    protected void doStart() throws Exception {
        boolean existingTask = this.taskScheduler.listsTasks().stream().anyMatch(info -> "repository.vulnerability.statistics".equals(info.getConfiguration().getTypeId()));
        if (existingTask) {
            return;
        }
        if (this.log4JVisualizerManager.isLog4JVisualizerEnabled()) {
            TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("repository.vulnerability.statistics");
            Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), this.vulnerabilityStatisticsCron);
            this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
        }
    }
}

