/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.http.impl.client.CloseableHttpClient;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class VulnerabilityInfoService
extends StateGuardLifecycleSupport {
    private final String url;
    private final Provider<CloseableHttpClient> httpClientProvider;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String defaultVulnerableVersions;
    private final boolean canRequestNewInfo;
    private Map<String, List<String>> componentVersionVulnerabilityMap;

    @Inject
    public VulnerabilityInfoService(@Nullable @Named(value="${nexus.vuln.infoService.defaultVersionsJson}") @Nullable @Named(value="${nexus.vuln.infoService.defaultVersionsJson}") String defaultVulnerableVersions, @Nullable @Named(value="${nexus.vuln.infoService.url}") @Nullable @Named(value="${nexus.vuln.infoService.url}") String url, @Named(value="${nexus.vuln.infoService.enabled:-false") @Named(value="${nexus.vuln.infoService.enabled:-false") boolean canRequestNewInfo, Provider<CloseableHttpClient> httpClientProvider) {
        this.httpClientProvider = (Provider)Preconditions.checkNotNull(httpClientProvider);
        this.url = url;
        this.defaultVulnerableVersions = defaultVulnerableVersions == null ? this.readStubbedData() : defaultVulnerableVersions;
        this.canRequestNewInfo = canRequestNewInfo;
    }

    protected void doStart() {
        String jsonDoc = this.canRequestNewInfo ? this.fetchRemoteVulnerabilityInfo().orElse("") : this.defaultVulnerableVersions;
        try {
            this.componentVersionVulnerabilityMap = this.parseJson(jsonDoc);
        }
        catch (JsonProcessingException jsonProcessingException) {
            if (this.canRequestNewInfo) {
                this.log.info("Failed to process {}, trying again with local version {}", (Object)this.url, (Object)this.defaultVulnerableVersions);
                try {
                    this.componentVersionVulnerabilityMap = this.parseJson(this.defaultVulnerableVersions);
                }
                catch (JsonProcessingException jsonProcessingException2) {
                    this.log.info("Default parse failed, assuming no vuln info");
                    this.componentVersionVulnerabilityMap = new HashMap<String, List<String>>();
                }
            }
            this.log.info("Default parse failed, assuming no vuln info");
            this.componentVersionVulnerabilityMap = new HashMap<String, List<String>>();
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<String> fetchRemoteVulnerabilityInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, List<String>> parseJson(String jsonString) throws JsonProcessingException {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        JsonNode jsonObj = this.objectMapper.readTree(jsonString);
        JsonNode componentArray = jsonObj.get("components");
        for (JsonNode component : componentArray) {
            String componentName = component.get("name").asText();
            JsonNode vulnerableVersionsArray = component.get("vulnerableVersions");
            ArrayList versions = new ArrayList();
            vulnerableVersionsArray.forEach(version -> {
                boolean bl = versions.add(version.asText());
            });
            resultMap.put(componentName, versions);
        }
        return resultMap;
    }

    public Map<String, List<String>> getVulnerableComponentsAndVersions() {
        return ImmutableMap.copyOf(this.componentVersionVulnerabilityMap);
    }

    private String readStubbedData() {
        try {
            return Joiner.on((char)'\n').join((Iterable)Resources.readLines((URL)Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("/com/sonatype/nexus/vulnerability/internal/log/vulnerability_info.json")), (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.log.debug("Failed to read stubbed vuln data", (Throwable)e);
            return "{ \"components\": [ { \"name\":\"log4j-core\", \"logPattern\":\"log4j-core\", \"vulnerableVersions\":[\"2.12.1\", \"2.13.0\", \"2.15.0\"] } ] }";
        }
    }
}

