/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.log;

import com.sonatype.nexus.vulnerability.internal.log.LogInformation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;

public class RequestLogAggregation
extends ComponentSupport {
    private final Map<DownloadKey, Integer> results = new HashMap<DownloadKey, Integer>();
    private LocalDateTime start;
    private LocalDateTime end;

    public LocalDateTime getStart() {
        return this.start;
    }

    public void setStart(LocalDateTime start) {
        if (Objects.nonNull(start) && (Objects.isNull(this.start) || start.isBefore(this.start))) {
            this.start = start;
        }
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public void setEnd(LocalDateTime end) {
        if (Objects.nonNull(end) && (Objects.isNull(this.end) || end.isAfter(this.end))) {
            this.end = end;
        }
    }

    public Map<DownloadKey, Integer> getResults() {
        return Collections.unmodifiableMap(this.results);
    }

    public synchronized void increment(@Nonnull LogInformation logInformation) {
        DownloadKey key = new DownloadKey(logInformation.getAssetName(), logInformation.getVersion(), logInformation.getUser(), logInformation.getIpAddress(), logInformation.getRepository(), logInformation.getDateTime().toLocalDate());
        this.results.merge(key, 1, Integer::sum);
    }

    public static class DownloadKey {
        private final String assetName;
        private final String version;
        private final String user;
        private final String ipAddress;
        private final String sourceRepo;
        private final LocalDate downloadDate;

        public DownloadKey(String assetName, String version, String user, String ipAddress, String sourceRepo, LocalDate downloadDate) {
            this.assetName = assetName;
            this.version = version;
            this.user = user;
            this.ipAddress = ipAddress;
            this.sourceRepo = sourceRepo;
            this.downloadDate = downloadDate;
        }

        public String getAssetName() {
            return this.assetName;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUser() {
            return this.user;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getSourceRepo() {
            return this.sourceRepo;
        }

        public LocalDate getDownloadDate() {
            return this.downloadDate;
        }

        public int hashCode() {
            return Objects.hash(this.assetName, this.downloadDate, this.ipAddress, this.sourceRepo, this.user, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DownloadKey other = (DownloadKey)obj;
            return Objects.equals(this.assetName, other.assetName) && Objects.equals(this.downloadDate, other.downloadDate) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.sourceRepo, other.sourceRepo) && Objects.equals(this.user, other.user) && Objects.equals(this.version, other.version);
        }
    }
}

