/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.log;

import java.time.OffsetDateTime;

public class LogInformation {
    private OffsetDateTime dateTime;
    private String assetName;
    private String ipAddress;
    private String user;
    private String path;
    private String version;
    private String repository;

    public LogInformation(Builder builder) {
        this.dateTime = builder.dateTime;
        this.assetName = builder.assetName;
        this.ipAddress = builder.ipAddress;
        this.user = builder.user;
        this.path = builder.path;
        this.version = builder.version;
        this.repository = builder.repository;
    }

    public static Builder builder() {
        return new Builder();
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getUser() {
        return this.user;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRepository() {
        return this.repository;
    }

    public static class Builder {
        private OffsetDateTime dateTime;
        private String assetName;
        private String ipAddress;
        private String user;
        private String path;
        private String version;
        private String repository;

        public Builder dateTime(OffsetDateTime dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public LogInformation build() {
            return new LogInformation(this);
        }
    }
}

