/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.legal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sonatype.nexus.vulnerability.FirewallConfigurationChecker;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.security.SecurityHelper;

@Named
@Singleton
public class FirewallConfigurationCheckerImpl
extends ComponentSupport
implements FirewallConfigurationChecker {
    private static final String APPLICATION_LICENSE_FEATURES = "features";
    private static final String CLM_CAPABILITY_ID = "clm";
    private static final String CLM_FEATURE = "SonatypeCLM";
    private static final String FIREWALL_FEATURE = "Firewall";
    private final CapabilityRegistry capabilities;
    private final SecurityHelper securityHelper;
    private final ApplicationLicense applicationLicense;

    @Inject
    public FirewallConfigurationCheckerImpl(CapabilityRegistry capabilityRegistry, SecurityHelper securityHelper, ApplicationLicense applicationLicense) {
        this.capabilities = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.applicationLicense = (ApplicationLicense)Preconditions.checkNotNull((Object)applicationLicense);
    }

    private Optional<CapabilityContext> findFirewallCapability() {
        Collection references = this.capabilities.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(CapabilityType.capabilityType((String)CLM_CAPABILITY_ID)).includeNotExposed());
        if (references.isEmpty()) {
            return Optional.empty();
        }
        CapabilityContext context = ((CapabilityReference)references.iterator().next()).context();
        return Optional.of(context);
    }

    @Override
    public boolean showFirewallAlert() {
        if (!this.securityHelper.subject().hasRole("nx-admin")) {
            return false;
        }
        Object features = this.applicationLicense.getAttributes().get(APPLICATION_LICENSE_FEATURES);
        if (features instanceof Collection) {
            Collection featureCollection = (Collection)features;
            Optional<Object> firewallFeature = featureCollection.stream().filter(x -> x.equals(CLM_FEATURE) || x.equals(FIREWALL_FEATURE)).findFirst();
            if (!firewallFeature.isPresent()) {
                return false;
            }
        } else {
            return false;
        }
        Optional<CapabilityContext> firewallCapability = this.findFirewallCapability();
        return !firewallCapability.isPresent() || !firewallCapability.get().isEnabled();
    }
}

