/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.datastore;

import com.sonatype.nexus.vulnerability.internal.AggregatedDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DayDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DownloadCountStore;
import com.sonatype.nexus.vulnerability.internal.datastore.DownloadCountDAO;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class DownloadCountStoreImpl
extends ConfigStoreSupport<DownloadCountDAO>
implements DownloadCountStore {
    @Inject
    public DownloadCountStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    @Transactional
    public void add(String repositoryName, String namespace, String name, String version, LocalDate downloadDate, String ipAddress, String username, int downloadCount) {
        try {
            ((DownloadCountDAO)this.dao()).add(repositoryName, namespace, name, version, downloadDate, ipAddress, username, downloadCount);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            ((DownloadCountDAO)this.dao()).update(repositoryName, namespace, name, version, downloadDate, ipAddress, username, downloadCount);
        }
    }

    @Override
    @Transactional
    public List<AggregatedDownloadCount> getDownloadCountByIp(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return ((DownloadCountDAO)this.dao()).getDownloadCountByIp(namespace, name, version, start, end);
    }

    @Override
    @Transactional
    public List<AggregatedDownloadCount> getDownloadCountByRepositoryName(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return ((DownloadCountDAO)this.dao()).getDownloadCountByRepositoryName(namespace, name, version, start, end);
    }

    @Override
    @Transactional
    public List<AggregatedDownloadCount> getDownloadCountByUsername(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return ((DownloadCountDAO)this.dao()).getDownloadCountByUsername(namespace, name, version, start, end);
    }

    @Override
    @Transactional
    public List<DayDownloadCount> getDownloadsByDay(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return ((DownloadCountDAO)this.dao()).getDownloadCountByDay(namespace, name, version, start, end);
    }

    @Override
    @Transactional
    public List<DayDownloadCount> getNonVulnerableDownloadsByDay(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return ((DownloadCountDAO)this.dao()).getNonVulnerableDownloadCountByDay(namespace, name, version, start, end);
    }

    @Override
    @Transactional
    public void purge() {
        ((DownloadCountDAO)this.dao()).purge();
    }
}

