/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.capability;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.vulnerability.Log4JVisualizerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.FormField;

@Named(value="log4j-visualizer")
public class Log4JVisualizerCapability
extends CapabilitySupport<Configuration> {
    public static final String TYPE_ID = "log4j-visualizer";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"log4j-visualizer");
    private final Log4JVisualizerManager log4JVisualizerManager;
    static final Messages messages = (Messages)I18N.create(Messages.class);

    @Inject
    public Log4JVisualizerCapability(Log4JVisualizerManager legalDisclaimerManager) {
        this.log4JVisualizerManager = (Log4JVisualizerManager)Preconditions.checkNotNull((Object)legalDisclaimerManager);
    }

    protected Configuration createConfig(Map<String, String> properties) throws Exception {
        return new Configuration(properties);
    }

    @Nullable
    protected String renderDescription() throws Exception {
        if (this.context().isActive()) {
            return messages.enabled();
        }
        return messages.disabled();
    }

    public void onActivate() {
        this.log4JVisualizerManager.setLog4JVisualizerEnabled(true, false);
    }

    public void onPassivate() {
        this.log4JVisualizerManager.setLog4JVisualizerEnabled(false, false);
    }

    public static class Configuration
    extends CapabilityConfigurationSupport {
        public Configuration(Map<String, String> properties) {
        }
    }

    @AvailabilityVersion(from="1.0")
    @Named(value="log4j-visualizer")
    @Singleton
    public static class Descriptor
    extends CapabilityDescriptorSupport<Configuration>
    implements Taggable {
        public Descriptor() {
            this.setExposed(true);
            this.setHidden(false);
        }

        public CapabilityType type() {
            return TYPE;
        }

        public String name() {
            return messages.name();
        }

        protected String renderAbout() throws Exception {
            return this.render("log4j-visualizer-about.vm");
        }

        public List<FormField> formFields() {
            return new ArrayList<FormField>();
        }

        public Set<Tag> getTags() {
            return new HashSet<Tag>(Collections.singletonList(Tag.categoryTag((String)messages.category())));
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Log4J Visualizer")
        public String name();

        @MessageBundle.DefaultMessage(value="UI")
        public String category();

        @MessageBundle.DefaultMessage(value="Enabled")
        public String enabled();

        @MessageBundle.DefaultMessage(value="Disabled")
        public String disabled();
    }
}

