/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal;

import com.sonatype.nexus.vulnerability.internal.AggregatedDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DayDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DownloadCountStore;
import com.sonatype.nexus.vulnerability.internal.Log4jVisualizerAnalytics;
import com.sonatype.nexus.vulnerability.internal.log.VulnerabilityInfoService;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.rest.Resource;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Named
@Singleton
@Path(value="/v1/vulnerability")
public class VulnerabilityResource
implements Resource {
    private final DownloadCountStore downloadCountStore;
    private final VulnerabilityInfoService vulnerabilityInfoService;
    private final Log4jVisualizerAnalytics log4jVisualizerAnalytics;

    @Inject
    public VulnerabilityResource(DownloadCountStore downloadCountStore, VulnerabilityInfoService vulnerabilityInfoService, Log4jVisualizerAnalytics log4jVisualizerAnalytics) {
        this.downloadCountStore = downloadCountStore;
        this.vulnerabilityInfoService = vulnerabilityInfoService;
        this.log4jVisualizerAnalytics = log4jVisualizerAnalytics;
    }

    @GET
    @Path(value="/components-and-versions")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public Object getVulnerableComponentsAndVersions() {
        return this.vulnerabilityInfoService.getVulnerableComponentsAndVersions();
    }

    @GET
    @Path(value="/count-by-ip")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public List<AggregatedDownloadCount> getDownloadCountByIp() {
        return this.vulnerabilityInfoService.getVulnerableComponentsAndVersions().entrySet().stream().flatMap(entry -> this.downloadCountStore.getDownloadCountByIp("", (String)entry.getKey(), (Collection)entry.getValue(), VulnerabilityResource.oneYearAgo(), VulnerabilityResource.tomorrow()).stream()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/count-by-repository-name")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public List<AggregatedDownloadCount> getDownloadCountByRepositoryName() {
        return this.vulnerabilityInfoService.getVulnerableComponentsAndVersions().entrySet().stream().flatMap(entry -> this.downloadCountStore.getDownloadCountByRepositoryName("", (String)entry.getKey(), (Collection)entry.getValue(), VulnerabilityResource.oneYearAgo(), VulnerabilityResource.tomorrow()).stream()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/count-by-username")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public List<AggregatedDownloadCount> getDownloadCountByUsername() {
        return this.vulnerabilityInfoService.getVulnerableComponentsAndVersions().entrySet().stream().flatMap(entry -> this.downloadCountStore.getDownloadCountByUsername("", (String)entry.getKey(), (Collection)entry.getValue(), VulnerabilityResource.oneYearAgo(), VulnerabilityResource.tomorrow()).stream()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/count-total")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public Long getTotalDownloads() {
        this.log4jVisualizerAnalytics.incrementPageLoadCount();
        return this.getDownloadCountByRepositoryName().stream().mapToLong(AggregatedDownloadCount::getDownloadCount).sum();
    }

    @GET
    @Path(value="/count-by-day")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public List<DayDownloadCount> getDownloadsCountByDay() {
        return this.vulnerabilityInfoService.getVulnerableComponentsAndVersions().entrySet().stream().flatMap(entry -> this.downloadCountStore.getDownloadsByDay("", (String)entry.getKey(), (Collection)entry.getValue(), VulnerabilityResource.oneYearAgo(), VulnerabilityResource.tomorrow()).stream()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/count-by-day-non-vulnerable")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public List<DayDownloadCount> getNonVulnerableDownloadsCountByDay() {
        return this.vulnerabilityInfoService.getVulnerableComponentsAndVersions().entrySet().stream().flatMap(entry -> this.downloadCountStore.getNonVulnerableDownloadsByDay("", (String)entry.getKey(), (Collection)entry.getValue(), VulnerabilityResource.oneYearAgo(), VulnerabilityResource.tomorrow()).stream()).collect(Collectors.toList());
    }

    private static LocalDate oneYearAgo() {
        return LocalDate.now().minusYears(1L);
    }

    private static LocalDate tomorrow() {
        return LocalDate.now().plusDays(1L);
    }
}

