/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class DayDownloadCount {
    private final LocalDate day;
    private final long downloadCount;

    public DayDownloadCount(LocalDate day, long downloadCount) {
        this.day = day;
        this.downloadCount = downloadCount;
    }

    public DayDownloadCount(LocalDate day, Long downloadCount) {
        this(day, (long)((Long)Preconditions.checkNotNull((Object)downloadCount)));
    }

    public String getDay() {
        return this.day.format(DateTimeFormatter.ofPattern("MM/dd/yyyy"));
    }

    public long getDownloadCount() {
        return this.downloadCount;
    }

    public int hashCode() {
        return Objects.hash(this.day, this.downloadCount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DayDownloadCount other = (DayDownloadCount)obj;
        return Objects.equals(this.day, other.day) && this.downloadCount == other.downloadCount;
    }

    public String toString() {
        return "day=" + this.day + "\ndownloadCount=" + this.downloadCount;
    }
}

