/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.outreach;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.Hashing;
import com.sonatype.nexus.licensing.ext.LicenseChangedEvent;
import com.sonatype.nexus.plugins.outreach.Outreach;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.OutreachManagementCapability;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.OutreachManagementCapabilityConfiguration;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.OutreachManagementCapabilityDescriptor;
import com.sonatype.nexus.plugins.outreach.internal.outreach.OutreachConnector;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundle;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundleMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.StatusLine;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.ReadablePeriod;
import org.sonatype.licensing.product.util.LicenseFingerprinter;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class SonatypeOutreach
extends StateGuardLifecycleSupport
implements Outreach {
    private static final String CPREFIX = "${nexus.outreach";
    private final File tmpdir;
    private final boolean alwaysRefresh;
    private final OutreachConnector connector;
    private final ApplicationLicense applicationLicense;
    private final ApplicationVersion applicationVersion;
    private final Map<String, PageBundle> bundles = Maps.newHashMap();
    private final CapabilityRegistry capabilities;
    private final EventManager eventManager;
    private final LicenseFingerprinter licenseFingerprinter;

    @Inject
    public SonatypeOutreach(OutreachConnector connector, ApplicationLicense applicationLicense, ApplicationVersion applicationVersion, CapabilityRegistry capabilities, ApplicationDirectories applicationDirectories, @Named(value="${nexus.outreach.alwaysRefresh:-false}") @Named(value="${nexus.outreach.alwaysRefresh:-false}") boolean alwaysRefresh, EventManager eventManager, LicenseFingerprinter licenseFingerprinter) {
        this.capabilities = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilities);
        this.connector = (OutreachConnector)((Object)Preconditions.checkNotNull((Object)((Object)connector)));
        this.applicationLicense = (ApplicationLicense)Preconditions.checkNotNull((Object)applicationLicense);
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
        try {
            this.tmpdir = ((ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories)).getTemporaryDirectory().getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.alwaysRefresh = alwaysRefresh;
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.licenseFingerprinter = (LicenseFingerprinter)Preconditions.checkNotNull((Object)licenseFingerprinter);
    }

    private String s(String part) {
        return part.charAt(0) == '/' ? part : "/" + part;
    }

    private String p(String key, String value) {
        return key.charAt(0) == '?' ? String.valueOf(key) + "=" + value : "?" + key + "=" + value;
    }

    private String sha(String s) {
        return Hashing.sha1().hashString((CharSequence)s, StandardCharsets.UTF_8).toString();
    }

    @Override
    public PageBundle getPageBundle(Outreach.User user, Locale locale) {
        return this.getOutreachBundle(this.getOutreachUrl(user, locale, this.applicationVersion, this.config(this.capability(this.reference()))));
    }

    private PageBundle getOutreachBundle(String url) {
        this.log.trace("URL: {}", (Object)url);
        String id = this.sha(url);
        PageBundle bundle = this.getOrCreatePageBundle(id);
        if (this.isOutreachActive() && this.shouldCallRemote(bundle)) {
            try {
                this.remote(url, bundle);
            }
            catch (IOException e) {
                this.log.warn("Could not download page bundle", (Throwable)e);
            }
        }
        return bundle;
    }

    private boolean shouldCallRemote(PageBundle pageBundle) {
        boolean wasNeverUpdated;
        boolean doesNotExist = !pageBundle.exists();
        boolean bl = wasNeverUpdated = pageBundle.lastModified() == 0L;
        return doesNotExist && wasNeverUpdated || this.needsRefresh(pageBundle);
    }

    private boolean isOutreachActive() {
        CapabilityContext context;
        boolean isActive = false;
        CapabilityReference reference = this.reference();
        if (reference != null && (context = reference.context()) != null) {
            isActive = context.isActive();
        }
        return isActive;
    }

    private PageBundle getOrCreatePageBundle(String id) {
        PageBundle bundle;
        if (this.bundles.containsKey(id)) {
            bundle = this.bundles.get(id);
        } else {
            bundle = new PageBundle(this.tmpdir, id);
            this.bundles.put(bundle.getId(), bundle);
        }
        return bundle;
    }

    private String getOutreachUrl(Outreach.User user, Locale locale, ApplicationVersion applicationVersion, OutreachManagementCapabilityConfiguration config) {
        Optional<String> licenseFingerprintHash;
        String edition = Strings2.lower((String)applicationVersion.getEdition());
        String editionSuffix = this.applicationLicense.isEvaluation() ? "-eval" : "";
        String version = applicationVersion.getVersion();
        String url = config.getOverrideUrl();
        if (Strings2.isEmpty((String)url)) {
            url = config.getBaseUrl();
            url = String.valueOf(url) + this.s(String.valueOf(edition) + editionSuffix) + this.s(version) + this.s(String.valueOf(locale.getLanguage()) + this.s(user.toString()));
        }
        if ((licenseFingerprintHash = this.getLicenseFingerprintHash()).isPresent()) {
            url = String.valueOf(url) + this.p("fingerprint", licenseFingerprintHash.get());
        }
        return url;
    }

    private Optional<String> getLicenseFingerprintHash() {
        Optional<String> hash;
        try {
            String fingerprint = this.licenseFingerprinter.calculate();
            hash = Optional.of(Hashing.sha512().hashString((CharSequence)fingerprint, StandardCharsets.UTF_8).toString());
        }
        catch (Exception exception) {
            hash = Optional.empty();
        }
        return hash;
    }

    @Subscribe
    public void licenseChanged(LicenseChangedEvent event) {
        if (event.isLicenseInstalled() && event.isLicenseValid()) {
            this.getOutreachBundle(this.getOutreachUrl(Outreach.User.NONE, Locale.US, this.applicationVersion, this.config(this.capability(this.reference()))));
        }
    }

    @VisibleForTesting
    synchronized void remote(String url, PageBundle bundle) throws IOException {
        Preconditions.checkNotNull((Object)url, (Object)"url must not be null");
        Preconditions.checkNotNull((Object)((Object)bundle), (Object)"bundle must not be null");
        this.log.trace("checking remote {} for bundle {}", (Object)url, (Object)bundle);
        if (bundle.lastModified() != 0L && !this.config(this.capability(this.reference())).isCachingDisabled()) {
            OutreachConnector.Response head = this.connector.head(url);
            this.log.trace("Head request for Outreach content responded with: {}", (Object)head);
            if (head.isSuccess() && head.lastModified() != null && head.lastModified().isBefore(bundle.lastModified())) {
                bundle.updated();
                return;
            }
        }
        OutreachConnector.Response get = this.connector.get(url);
        this.log.trace("Get request for Outreach content responded with: {}", (Object)get);
        StatusLine statusLine = get.getStatusLine();
        if (get.isSuccess()) {
            bundle.use(get.getFile());
        } else {
            bundle.updated();
            if (this.log.isInfoEnabled()) {
                this.log.info("Outreach bundle unavailable {} ({}:{})", new Object[]{url, statusLine.getStatusCode(), statusLine.getReasonPhrase()});
            }
        }
    }

    @VisibleForTesting
    boolean needsRefresh(PageBundle bundle) {
        PageBundleMetadata metadata = bundle.getMetaData();
        long timestamp = bundle.lastModified();
        if (this.alwaysRefresh || this.config(this.capability(this.reference())).isCachingDisabled()) {
            return true;
        }
        if (new DateTime(timestamp).plus((ReadablePeriod)Hours.ONE).isAfterNow()) {
            return false;
        }
        DateTime reference = metadata.getExpires();
        if (reference == null) {
            reference = new DateTime(timestamp).plus((ReadablePeriod)Days.ONE);
        }
        return reference.isBeforeNow();
    }

    protected void doStart() throws Exception {
        this.eventManager.register((Object)this);
    }

    protected void doStop() throws Exception {
        this.eventManager.unregister((Object)this);
        for (PageBundle pageBundle : this.bundles.values()) {
            pageBundle.dispose();
        }
        this.bundles.clear();
    }

    public boolean isOverrideUrlEmpty() {
        OutreachManagementCapabilityConfiguration config = this.config(this.capability(this.reference()));
        return config != null && StringUtils.isEmpty((CharSequence)config.getOverrideUrl());
    }

    private CapabilityReference reference() {
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter filter = CapabilityReferenceFilterBuilder.capabilities().withType(OutreachManagementCapabilityDescriptor.TYPE);
        Collection references = this.capabilities.get((Predicate)filter);
        if (!references.isEmpty()) {
            return (CapabilityReference)references.iterator().next();
        }
        return null;
    }

    private OutreachManagementCapability capability(CapabilityReference reference) {
        if (reference != null) {
            return (OutreachManagementCapability)reference.capability();
        }
        return null;
    }

    private OutreachManagementCapabilityConfiguration config(OutreachManagementCapability capability) {
        if (capability != null) {
            return (OutreachManagementCapabilityConfiguration)((Object)capability.getConfig());
        }
        return new OutreachManagementCapabilityConfiguration(Collections.emptyMap());
    }
}

